/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.jwt;

import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import com.atlassian.connect.spring.internal.jwt.CanonicalHttpUriRequest;
import com.atlassian.connect.spring.internal.jwt.HttpRequestCanonicalizer;
import com.atlassian.connect.spring.internal.jwt.JwtJsonBuilder;
import com.atlassian.connect.spring.internal.jwt.JwtWriter;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class JwtBuilder {
    private JwtJsonBuilder jwtJsonBuilder = new JwtJsonBuilder();
    private String sharedSecret;
    private Supplier<String> queryHashSupplier;

    public JwtBuilder issuer(String iss) {
        this.jwtJsonBuilder.issuer(iss);
        return this;
    }

    public JwtBuilder subject(String sub) {
        this.jwtJsonBuilder.subject(sub);
        return this;
    }

    public JwtBuilder audience(String aud) {
        this.jwtJsonBuilder.audience(aud);
        return this;
    }

    public JwtBuilder expirationTime(long exp) {
        this.jwtJsonBuilder.expirationTime(exp);
        return this;
    }

    public JwtBuilder notBefore(long nbf) {
        this.jwtJsonBuilder.notBefore(nbf);
        return this;
    }

    public JwtBuilder issuedAt(long iat) {
        this.jwtJsonBuilder.issuedAt(iat);
        return this;
    }

    public JwtBuilder queryHash(HttpMethod httpMethod, URI uri, String baseUrl) {
        this.queryHashSupplier = () -> this.computeCanonicalRequestHash(httpMethod, uri, baseUrl);
        return this;
    }

    public JwtBuilder claim(String name, Object value) {
        this.jwtJsonBuilder.claim(name, value);
        return this;
    }

    public JwtBuilder signature(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        return this;
    }

    public String build() {
        this.jwtJsonBuilder.queryHash(this.queryHashSupplier.get());
        String jwtPayload = this.jwtJsonBuilder.build();
        return this.createJwtWriter().jsonToJwt(jwtPayload);
    }

    private JwtWriter createJwtWriter() {
        return new JwtWriter(JWSAlgorithm.HS256, (JWSSigner)new MACSigner(this.sharedSecret));
    }

    public String toString() {
        return this.build();
    }

    protected String computeCanonicalRequestHash(HttpMethod httpMethod, URI uri, String baseUrl) {
        CanonicalHttpRequest canonicalHttpRequest = this.createCanonicalHttpRequest(httpMethod, uri, baseUrl);
        try {
            return HttpRequestCanonicalizer.computeCanonicalRequestHash((CanonicalHttpRequest)canonicalHttpRequest);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected CanonicalHttpRequest createCanonicalHttpRequest(HttpMethod httpMethod, URI uri, String baseUrl) {
        MultiValueMap queryParams = UriComponentsBuilder.fromUri((URI)uri).build().getQueryParams();
        URI hostBaseUri = UriComponentsBuilder.fromHttpUrl((String)baseUrl).build().toUri();
        return new CanonicalHttpUriRequest(httpMethod.name(), uri.getPath(), hostBaseUri.getPath(), JwtBuilder.toArrayMap((MultiValueMap<String, String>)queryParams));
    }

    private static Map<String, String[]> toArrayMap(MultiValueMap<String, String> queryParams) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (Map.Entry entry : queryParams.entrySet()) {
            result.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
        }
        return result;
    }
}

