/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.lifecycle;

import com.atlassian.connect.spring.AddonInstalledEvent;
import com.atlassian.connect.spring.AddonUninstalledEvent;
import com.atlassian.connect.spring.AtlassianHost;
import com.atlassian.connect.spring.AtlassianHostRepository;
import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.AsynchronousApplicationEventPublisher;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptorLoader;
import com.atlassian.connect.spring.internal.lifecycle.LifecycleEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LifecycleController {
    private static final Logger log = LoggerFactory.getLogger(LifecycleController.class);
    @Autowired
    private AtlassianHostRepository hostRepository;
    @Autowired
    private AddonDescriptorLoader addonDescriptorLoader;
    @Autowired
    private AsynchronousApplicationEventPublisher eventPublisher;

    public static Method getInstalledMethod() {
        return LifecycleController.getSafeMethod("installed");
    }

    public static Method getUninstalledMethod() {
        return LifecycleController.getSafeMethod("uninstalled");
    }

    private static Method getSafeMethod(String name) {
        try {
            return LifecycleController.class.getMethod(name, LifecycleEvent.class, AtlassianHostUser.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public ResponseEntity installed(@Valid @RequestBody LifecycleEvent lifecycleEvent, @AuthenticationPrincipal AtlassianHostUser hostUser) {
        this.assertExpectedEventType(lifecycleEvent, "installed");
        if (hostUser == null) {
            Optional<AtlassianHost> maybeExistingHost = this.getHostFromLifecycleEvent(lifecycleEvent);
            if (maybeExistingHost.isPresent()) {
                log.error("Incoming installation request was not properly authenticated, but we have already installed the add-on for host " + lifecycleEvent.clientKey + ". Subsequent installation requests must include valid JWT. Returning 401.");
                return this.responseForMissingJwt();
            }
        } else {
            this.assertHostAuthorized(lifecycleEvent, hostUser);
        }
        AtlassianHost host = new AtlassianHost();
        host.setClientKey(lifecycleEvent.clientKey);
        host.setPublicKey(lifecycleEvent.publicKey);
        host.setOauthClientId(lifecycleEvent.oauthClientId);
        host.setSharedSecret(lifecycleEvent.sharedSecret);
        host.setBaseUrl(lifecycleEvent.baseUrl);
        host.setProductType(lifecycleEvent.productType);
        host.setDescription(lifecycleEvent.description);
        host.setServiceEntitlementNumber(lifecycleEvent.serviceEntitlementNumber);
        host.setAddonInstalled(true);
        this.hostRepository.save((Object)host);
        log.info("Saved host");
        this.eventPublisher.publishEventAsynchronously((ApplicationEvent)new AddonInstalledEvent((Object)this, host));
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    public ResponseEntity uninstalled(@Valid @RequestBody LifecycleEvent lifecycleEvent, @AuthenticationPrincipal AtlassianHostUser hostUser) {
        this.assertExpectedEventType(lifecycleEvent, "uninstalled");
        Optional<AtlassianHost> maybeExistingHost = this.getHostFromLifecycleEvent(lifecycleEvent);
        if (hostUser == null) {
            if (maybeExistingHost.isPresent()) {
                log.error("Incoming installation request was not properly authenticated, but we have already installed the add-on for host " + lifecycleEvent.clientKey + ". Subsequent installation requests must include valid JWT. Returning 401.");
                return this.responseForMissingJwt();
            }
        } else {
            this.assertHostAuthorized(lifecycleEvent, hostUser);
        }
        if (maybeExistingHost.isPresent()) {
            AtlassianHost host = maybeExistingHost.get();
            host.setAddonInstalled(false);
            this.hostRepository.save((Object)host);
            this.eventPublisher.publishEventAsynchronously((ApplicationEvent)new AddonUninstalledEvent((Object)this, host));
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private Optional<AtlassianHost> getHostFromLifecycleEvent(LifecycleEvent lifecycleEvent) {
        return Optional.ofNullable(this.hostRepository.findOne((Serializable)((Object)lifecycleEvent.clientKey)));
    }

    private void assertExpectedEventType(LifecycleEvent lifecycleEvent, String expectedEventType) {
        String eventType = lifecycleEvent.eventType;
        if (!expectedEventType.equals(eventType)) {
            log.error(String.format("Received lifecycle callback with unexpected event type %s, expected %s", eventType, expectedEventType));
            throw new InvalidLifecycleEventTypeException();
        }
    }

    private void assertHostAuthorized(LifecycleEvent lifecycleEvent, AtlassianHostUser hostUser) {
        if (!hostUser.getHost().getClientKey().equals(lifecycleEvent.clientKey)) {
            log.error("Installation request was authenticated for host " + hostUser.getHost().getClientKey() + ", but the host in the body of the request is " + lifecycleEvent.clientKey + ". Returning 403.");
            throw new HostForbiddenException();
        }
    }

    private ResponseEntity responseForMissingJwt() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("WWW-Authenticate", String.format("JWT realm=\"%s\"", this.addonDescriptorLoader.getDescriptor().getKey()));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).headers(headers)).build();
    }

    private ResponseEntity<Void> responseForUnauthorizedHost() {
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    @ResponseStatus(code=HttpStatus.FORBIDDEN)
    private static class HostForbiddenException
    extends RuntimeException {
        private HostForbiddenException() {
        }
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST, reason="Invalid lifecycle event type")
    private static class InvalidLifecycleEventTypeException
    extends RuntimeException {
        private InvalidLifecycleEventTypeException() {
        }
    }
}

