/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.descriptor;

import com.atlassian.connect.spring.internal.descriptor.AddonDescriptor;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;

@Component
public class AddonDescriptorLoader
implements ResourceLoaderAware {
    public static final String DESCRIPTOR_FILENAME = "atlassian-connect.json";
    public static final String DESCRIPTOR_RESOURCE_PATH = "classpath:atlassian-connect.json";
    private ResourceLoader resourceLoader;
    @Autowired
    private ConfigurableEnvironment configurableEnvironment;
    private ObjectMapper mapper = this.createObjectMapper();

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public AddonDescriptor getDescriptor() {
        String descriptor = this.getRawDescriptor();
        try {
            return (AddonDescriptor)this.mapper.readValue(descriptor, AddonDescriptor.class);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getRawDescriptor() {
        String rawDescriptor = this.getRawDescriptorQuietly();
        return this.configurableEnvironment.resolvePlaceholders(rawDescriptor);
    }

    private String getRawDescriptorQuietly() {
        try {
            return this.getDescriptorResourceContents();
        }
        catch (IOException e) {
            throw new AssertionError("Could not load add-on descriptor", e);
        }
    }

    private String getDescriptorResourceContents() throws IOException {
        Resource resource = this.resourceLoader.getResource(DESCRIPTOR_RESOURCE_PATH);
        if (!resource.exists()) {
            throw new IOException(String.format("No add-on descriptor found (%s)", DESCRIPTOR_FILENAME));
        }
        return StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset());
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setVisibility((VisibilityChecker)VisibilityChecker.Std.defaultInstance().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        return mapper;
    }
}

