/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.auth.jwt;

import com.atlassian.connect.spring.internal.AtlassianConnectProperties;
import com.atlassian.connect.spring.internal.auth.jwt.JwtAuthenticationToken;
import com.atlassian.connect.spring.internal.auth.jwt.JwtCredentials;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptor;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptorLoader;
import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import com.atlassian.connect.spring.internal.jwt.CanonicalHttpServletRequest;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    private static final String AUTHORIZATION_HEADER_SCHEME_PREFIX = "JWT ";
    private static final String QUERY_PARAMETER_NAME = "jwt";
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationFilter.class);
    private AuthenticationManager authenticationManager;
    private AuthenticationFailureHandler failureHandler;
    @Autowired
    private AddonDescriptorLoader addonDescriptorLoader;
    @Autowired
    private AtlassianConnectProperties atlassianConnectProperties;

    public JwtAuthenticationFilter(AuthenticationManager authenticationManager, ServerProperties serverProperties) {
        this.authenticationManager = authenticationManager;
        this.failureHandler = this.createFailureHandler(serverProperties);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        block3: {
            Optional<String> optionalJwt = JwtAuthenticationFilter.getJwtFromRequest(request);
            if (optionalJwt.isPresent()) {
                JwtAuthenticationToken authenticationRequest = this.createJwtAuthenticationToken(request, JwtAuthenticationFilter.getJwtFromRequest(request).get());
                try {
                    Authentication authenticationResult = this.authenticationManager.authenticate((Authentication)authenticationRequest);
                    SecurityContextHolder.getContext().setAuthentication(authenticationResult);
                }
                catch (AuthenticationException e) {
                    if (this.shouldIgnoreInvalidJwt(request, e)) break block3;
                    this.failureHandler.onAuthenticationFailure(request, response, e);
                    return;
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private SimpleUrlAuthenticationFailureHandler createFailureHandler(ServerProperties serverProperties) {
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler(serverProperties.getError().getPath());
        failureHandler.setAllowSessionCreation(false);
        failureHandler.setUseForward(true);
        return failureHandler;
    }

    private static Optional<String> getJwtFromRequest(HttpServletRequest request) {
        Optional<String> optionalJwt = JwtAuthenticationFilter.getJwtFromHeader(request);
        if (!optionalJwt.isPresent()) {
            optionalJwt = JwtAuthenticationFilter.getJwtFromParameter(request);
        }
        return optionalJwt;
    }

    private static Optional<String> getJwtFromHeader(HttpServletRequest request) {
        Optional<String> optionalJwt = Optional.empty();
        String authHeader = request.getHeader("Authorization");
        if (!StringUtils.isEmpty((CharSequence)authHeader) && authHeader.startsWith(AUTHORIZATION_HEADER_SCHEME_PREFIX)) {
            String jwt = authHeader.substring(AUTHORIZATION_HEADER_SCHEME_PREFIX.length());
            optionalJwt = Optional.of(jwt);
        }
        return optionalJwt;
    }

    private static Optional<String> getJwtFromParameter(HttpServletRequest request) {
        Optional<String> optionalJwt = Optional.empty();
        String jwt = request.getParameter(QUERY_PARAMETER_NAME);
        if (!StringUtils.isEmpty((CharSequence)jwt)) {
            optionalJwt = Optional.of(jwt);
        }
        return optionalJwt;
    }

    private JwtAuthenticationToken createJwtAuthenticationToken(HttpServletRequest request, String jwt) {
        log.debug("Retrieved JWT from request {}", (Object)jwt);
        CanonicalHttpServletRequest canonicalHttpServletRequest = new CanonicalHttpServletRequest(request);
        JwtCredentials credentials = new JwtCredentials(jwt, (CanonicalHttpRequest)canonicalHttpServletRequest);
        return new JwtAuthenticationToken(credentials);
    }

    private boolean shouldIgnoreInvalidJwt(HttpServletRequest request, AuthenticationException e) {
        return e instanceof UsernameNotFoundException && (this.isRequestToInstalledLifecycle(request) && this.atlassianConnectProperties.isAllowReinstallMissingHost() || this.isRequestToUninstalledLifecycle(request));
    }

    private boolean isRequestToInstalledLifecycle(HttpServletRequest request) {
        AddonDescriptor descriptor = this.addonDescriptorLoader.getDescriptor();
        String url = descriptor.getBaseUrl() + descriptor.getInstalledLifecycleUrl();
        return this.isRequestToUrl(request, url);
    }

    private boolean isRequestToUninstalledLifecycle(HttpServletRequest request) {
        AddonDescriptor descriptor = this.addonDescriptorLoader.getDescriptor();
        String url = descriptor.getBaseUrl() + descriptor.getUninstalledLifecycleUrl();
        return this.isRequestToUrl(request, url);
    }

    private boolean isRequestToUrl(HttpServletRequest request, String url) {
        UriComponents urlComponents = UriComponentsBuilder.fromUri((URI)URI.create(url)).build();
        UriComponents requestComponents = UriComponentsBuilder.fromUri((URI)URI.create(request.getRequestURL().toString())).query(request.getQueryString()).build();
        return StringUtils.equals((CharSequence)requestComponents.getPath(), (CharSequence)urlComponents.getPath()) && requestComponents.getQueryParams().entrySet().containsAll(urlComponents.getQueryParams().entrySet());
    }
}

