/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.auth.jwt;

import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.jwt.Jwt;
import java.util.Collection;
import java.util.Collections;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class JwtAuthentication
implements Authentication {
    public static final String ROLE_JWT = "ROLE_JWT";
    private final AtlassianHostUser hostUser;
    private final Jwt jwt;

    public JwtAuthentication(AtlassianHostUser hostUser, Jwt jwt) {
        this.hostUser = hostUser;
        this.jwt = jwt;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.singleton(new SimpleGrantedAuthority(ROLE_JWT));
    }

    public Object getCredentials() {
        return this.jwt;
    }

    public Object getDetails() {
        return null;
    }

    public Object getPrincipal() {
        return this.hostUser;
    }

    public boolean isAuthenticated() {
        return true;
    }

    public void setAuthenticated(boolean b) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(this.hostUser.getHost().getClientKey());
        this.hostUser.getUserKey().ifPresent(userKey -> nameBuilder.append(String.format(" (%s)", userKey)));
        return nameBuilder.toString();
    }
}

