/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal;

import com.atlassian.connect.spring.AtlassianHost;
import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.AtlassianConnectProperties;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ModelAttribute;

@ControllerAdvice
public class AtlassianConnectContextModelAttributeProvider {
    private static final String ALL_JS_FILENAME = "all.js";
    private static final String ALL_DEBUG_JS_FILENAME = "all-debug.js";
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private AtlassianConnectProperties atlassianConnectProperties;

    @ModelAttribute(value="atlassian-connect-license")
    public String getLicense() {
        return this.request.getParameter("lic");
    }

    @ModelAttribute(value="atlassian-connect-locale")
    public String getLocale() {
        return this.request.getParameter("loc");
    }

    @ModelAttribute(value="atlassian-connect-timezone")
    public String getTimezone() {
        return this.request.getParameter("tz");
    }

    @ModelAttribute(value="atlassian-connect-all-js-url")
    public String getAllJsUrl() {
        return this.getHostBaseUrl().map(this::createAllJsUrl).orElse("");
    }

    private Optional<String> getHostBaseUrl() {
        Optional<String> optionalBaseUrl = this.getHostBaseUrlFromPrincipal();
        if (!optionalBaseUrl.isPresent()) {
            optionalBaseUrl = this.getHostBaseUrlFromQueryParameters();
        }
        return optionalBaseUrl;
    }

    private Optional<String> getHostBaseUrlFromPrincipal() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Authentication::getPrincipal).filter(AtlassianHostUser.class::isInstance).map(AtlassianHostUser.class::cast).map(AtlassianHostUser::getHost).map(AtlassianHost::getBaseUrl);
    }

    private Optional<String> getHostBaseUrlFromQueryParameters() {
        String hostUrl = this.request.getParameter("xdm_e");
        String contextPath = this.request.getParameter("cp");
        Optional<String> optionalBaseUrl = Optional.empty();
        if (!StringUtils.isEmpty((Object)hostUrl)) {
            optionalBaseUrl = !StringUtils.isEmpty((Object)contextPath) ? Optional.of(hostUrl + contextPath) : Optional.of(hostUrl);
        }
        return optionalBaseUrl;
    }

    private String createAllJsUrl(String hostBaseUrl) {
        return String.format("%s/%s/%s", hostBaseUrl, "atlassian-connect", this.getAllJsFilename());
    }

    private String getAllJsFilename() {
        return this.atlassianConnectProperties.isDebugAllJs() ? ALL_DEBUG_JS_FILENAME : ALL_JS_FILENAME;
    }
}

