/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal;

import com.atlassian.connect.spring.internal.AtlassianConnectProperties;
import com.atlassian.connect.spring.internal.auth.jwt.JwtAuthenticationFilter;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.security.authentication.AuthenticationManager;

@Configuration
@ComponentScan(basePackageClasses={AtlassianConnectAutoConfiguration.class})
@EnableConfigurationProperties(value={AtlassianConnectProperties.class})
@ConditionalOnResource(resources={"classpath:atlassian-connect.json"})
@EnableCaching
@EnableAsync
public class AtlassianConnectAutoConfiguration {
    @Bean
    public Filter jwtAuthenticationFilter(AuthenticationManager authenticationManager, ServerProperties serverProperties) {
        return new JwtAuthenticationFilter(authenticationManager, serverProperties);
    }

    @Configuration
    @Profile(value={"production"})
    @PropertySource(value={"classpath:config/default.properties", "classpath:config/production.properties"})
    static class Production {
        Production() {
        }
    }

    @Configuration
    @PropertySource(value={"classpath:config/default.properties"})
    static class Defaults {
        Defaults() {
        }
    }
}

