/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.token;

import com.atlassian.fugue.Option;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Json;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class Token {
    private final String acHost;
    private final Option<String> user;
    private final long timestamp;
    private boolean allowInsecurePolling;

    public Token(String acHost, Option<String> user, long timestamp, boolean allowInsecurePolling) {
        this.acHost = acHost;
        this.user = user;
        this.timestamp = timestamp;
        this.allowInsecurePolling = allowInsecurePolling;
    }

    public String getAcHost() {
        return this.acHost;
    }

    public Option<String> getUser() {
        return this.user;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isAllowInsecurePolling() {
        return this.allowInsecurePolling;
    }

    public JsonNode toJson() {
        ObjectNode jsonToken = Json.newObject();
        jsonToken.put("h", this.acHost);
        if (this.user.isDefined()) {
            jsonToken.put("u", (String)this.user.get());
        }
        if (this.allowInsecurePolling) {
            jsonToken.put("p", "1");
        }
        jsonToken.put("t", System.currentTimeMillis());
        return jsonToken;
    }

    public static Token fromJson(JsonNode jsonToken) {
        return new Token(jsonToken.get("h").asText(), (Option<String>)Option.option((Object)jsonToken.get("u").asText()), jsonToken.get("t").asLong(), jsonToken.has("p"));
    }
}

