/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.play;

import com.atlassian.connect.play.java.AC;
import com.atlassian.connect.play.java.play.WithCacheControl;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import javax.annotation.Nullable;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.SimpleResult;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class CacheControlAction
extends Action<WithCacheControl> {
    private static final String DEFAULT_CACHE_CONTROL = Play.application().configuration().getString("ac.cache-control", AC.isDev() ? "no-cache" : null);

    public F.Promise<SimpleResult> call(Http.Context ctx) throws Throwable {
        if (!ctx.args.containsKey("Cache-Control")) {
            ctx.args.put("Cache-Control", this.getCacheControl());
        }
        F.Promise result = this.delegate.call(ctx);
        String cacheControl = (String)ctx.args.get("Cache-Control");
        Http.Response response = ctx.response();
        if (cacheControl != null && !CacheControlAction.responseCacheControlIsSet(response)) {
            response.setHeader("Cache-Control", cacheControl);
        }
        return result;
    }

    public String getCacheControl() {
        return (String)Option.option((Object)this.configuration).map((Function)new Function<WithCacheControl, String>(){

            @Nullable
            public String apply(WithCacheControl annotation) {
                return annotation.value();
            }
        }).getOrElse((Object)DEFAULT_CACHE_CONTROL);
    }

    private static boolean responseCacheControlIsSet(Http.Response response) {
        return response.getHeaders().containsKey("Cache-Control");
    }
}

