/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.controllers;

import com.atlassian.connect.play.java.AC;
import com.atlassian.connect.play.java.AcHost;
import com.atlassian.connect.play.java.controllers.IsDevAction;
import com.atlassian.connect.play.java.service.AcHostService;
import com.atlassian.connect.play.java.service.InjectorFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.Json;
import play.libs.WS;
import play.mvc.Content;
import play.mvc.Result;
import play.mvc.Results;
import play.mvc.With;
import views.html.ac.internal.admin.index;

@With(value={IsDevAction.class})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AcAdmin {
    private static final AcHostService acHostService = InjectorFactory.getAcHostService();

    public static Result index() {
        try {
            return Results.ok((Content)index.render(acHostService.all()));
        }
        catch (Throwable throwable) {
            return Results.internalServerError((JsonNode)AcAdmin.message("Error accessing the database", throwable.getMessage()));
        }
    }

    public static F.Promise<Result> clearMacroCache(String key) {
        return (F.Promise)AC.getAcHost(key).fold(AcAdmin.noAcHost(), (Function)new Function<AcHost, F.Promise<Result>>(){

            public F.Promise<Result> apply(final AcHost host) {
                return AC.url("/rest/atlassian-connect/1/macro/app/" + AC.PLUGIN_KEY, host).delete().map((F.Function)new F.Function<WS.Response, Result>(){

                    public Result apply(WS.Response response) throws Throwable {
                        if (response.getStatus() == 204) {
                            return Results.ok((JsonNode)AcAdmin.message("Cache cleared", String.format("The macro cache for host at '%s' was cleared.", host.getBaseUrl())));
                        }
                        return Results.badRequest((JsonNode)AcAdmin.message("Unknown error", String.format("An unknown error happened clearing the cache for host at '%s'. Http status is %s (%s).", host.getBaseUrl(), response.getStatus(), response.getStatusText())));
                    }
                });
            }
        });
    }

    private static Supplier<F.Promise<Result>> noAcHost() {
        return new Supplier<F.Promise<Result>>(){

            public F.Promise<Result> get() {
                return F.Promise.pure((Object)Results.badRequest((JsonNode)AcAdmin.message("No AC host", "Couldn't find AC host to send request to.")));
            }
        };
    }

    public static JsonNode message(String title, String message2) {
        ObjectNode result = Json.newObject();
        result.put("title", title);
        result.put("message", message2);
        return result;
    }
}

