/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.auth.jwt;

import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.core.http.HttpRequestWrapper;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PlayRequestWrapper
implements HttpRequestWrapper {
    private final Http.Request request;
    private final String addonContext;

    public PlayRequestWrapper(Http.Request request, String addonContext) {
        this.request = request;
        this.addonContext = addonContext;
    }

    @Nullable
    public String getParameter(String parameterName) {
        return this.request.getQueryString(parameterName);
    }

    public Iterable<String> getHeaderValues(String headerName) {
        String[] headerValues = null;
        Map headers = this.request.headers();
        for (String h : headers.keySet()) {
            if (!headerName.toLowerCase().equals(h.toLowerCase())) continue;
            headerValues = (String[])headers.get(h);
            break;
        }
        return headerValues != null ? Arrays.asList(headerValues) : ImmutableList.of();
    }

    public CanonicalHttpRequest getCanonicalHttpRequest() {
        return new CanonicalHttpRequest(){

            @Nonnull
            public String getMethod() {
                return PlayRequestWrapper.this.request.method();
            }

            @Nullable
            public String getRelativePath() {
                return StringUtils.removeStart((String)PlayRequestWrapper.this.request.path(), (String)PlayRequestWrapper.this.addonContext);
            }

            @Nonnull
            public Map<String, String[]> getParameterMap() {
                return PlayRequestWrapper.this.request.queryString();
            }
        };
    }
}

