/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.auth.jwt;

import com.atlassian.connect.play.java.auth.jwt.JwtAuthenticationResult;
import com.atlassian.connect.play.java.util.Utils;
import com.atlassian.jwt.Jwt;
import com.atlassian.jwt.core.http.auth.AuthenticationResultHandler;
import java.security.Principal;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;
import play.mvc.Results;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PlayAuthenticationResultHandler
implements AuthenticationResultHandler<Http.Response, JwtAuthenticationResult> {
    public JwtAuthenticationResult createAndSendInternalError(Exception e, Http.Response response, String externallyVisibleMessage) {
        return PlayAuthenticationResultHandler.createError(e, 500, externallyVisibleMessage);
    }

    public JwtAuthenticationResult createAndSendBadRequestError(Exception e, Http.Response response, String externallyVisibleMessage) {
        return PlayAuthenticationResultHandler.createError(e, 400, externallyVisibleMessage);
    }

    public JwtAuthenticationResult createAndSendUnauthorisedFailure(Exception e, Http.Response response, String externallyVisibleMessage) {
        return PlayAuthenticationResultHandler.createFailure(e, 401, externallyVisibleMessage);
    }

    public JwtAuthenticationResult createAndSendForbiddenError(Exception e, Http.Response response) {
        return PlayAuthenticationResultHandler.createError(e, 403, "Access to this resource is forbidden without successful authentication. Please supply valid credentials.");
    }

    public JwtAuthenticationResult success(String message2, Principal principal, Jwt authenticatedJwt) {
        return new JwtAuthenticationResult(authenticatedJwt);
    }

    private static JwtAuthenticationResult createError(Exception e, int httpResponseCode, String externallyVisibleMessage) {
        Utils.LOGGER.info("Error during JWT authentication: ", (Throwable)e);
        return PlayAuthenticationResultHandler.createErrorResult(httpResponseCode, externallyVisibleMessage);
    }

    private static JwtAuthenticationResult createFailure(Exception e, int httpResponseCode, String externallyVisibleMessage) {
        Utils.LOGGER.info("Failure during JWT authentication: ", (Throwable)e);
        return PlayAuthenticationResultHandler.createErrorResult(httpResponseCode, externallyVisibleMessage);
    }

    private static JwtAuthenticationResult createErrorResult(int httpResponseCode, String externallyVisibleMessage) {
        return new JwtAuthenticationResult(Results.status((int)httpResponseCode, (String)externallyVisibleMessage));
    }
}

