/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.auth.jwt;

import com.atlassian.connect.play.java.AC;
import com.atlassian.connect.play.java.auth.InvalidAuthenticationRequestException;
import com.atlassian.connect.play.java.auth.jwt.JwtAuthConfig;
import com.atlassian.connect.play.java.auth.jwt.JwtAuthenticationResult;
import com.atlassian.jwt.Jwt;
import com.atlassian.jwt.core.http.auth.JwtAuthenticator;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Results;
import play.mvc.SimpleResult;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class JwtRequestAuthenticatorAction
extends Action.Simple {
    private static final JwtAuthenticator<Http.Request, Http.Response, JwtAuthenticationResult> authenticator = JwtAuthConfig.getJwtAuthenticator();

    public F.Promise<SimpleResult> call(Http.Context context) throws Throwable {
        return new AuthenticationHelper().authenticate(context, this.delegate);
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    static class AuthenticationHelper {
        AuthenticationHelper() {
        }

        public F.Promise<SimpleResult> authenticate(Http.Context context, Action delegate) throws Throwable {
            try {
                F.Either<Results.Status, Jwt> authResult = ((JwtAuthenticationResult)authenticator.authenticate((Object)context.request(), (Object)context.response())).getResult();
                if (authResult.left.isDefined()) {
                    return F.Promise.pure((Object)((SimpleResult)authResult.left.get()));
                }
                Jwt jwt = (Jwt)authResult.right.get();
                AC.setAcHost(jwt.getIssuer());
                AC.setUser(jwt.getSubject());
                AC.refreshToken(false);
                return delegate.call(context);
            }
            catch (InvalidAuthenticationRequestException e) {
                return F.Promise.pure((Object)Results.badRequest((String)("Bad request: " + e.getMessage())));
            }
        }
    }
}

