/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.auth.jwt;

import com.atlassian.connect.play.java.AC;
import com.atlassian.connect.play.java.auth.jwt.ACPlayJwtIssuerService;
import com.atlassian.connect.play.java.auth.jwt.JwtAuthenticationResult;
import com.atlassian.connect.play.java.auth.jwt.JwtAuthorizationGenerator;
import com.atlassian.connect.play.java.auth.jwt.PlayAuthenticationResultHandler;
import com.atlassian.connect.play.java.auth.jwt.PlayJwtAuthenticator;
import com.atlassian.connect.play.java.auth.jwt.PlayJwtRequestExtractor;
import com.atlassian.jwt.core.http.JwtRequestExtractor;
import com.atlassian.jwt.core.http.auth.JwtAuthenticator;
import com.atlassian.jwt.core.reader.JwtIssuerSharedSecretService;
import com.atlassian.jwt.core.reader.JwtIssuerValidator;
import com.atlassian.jwt.core.reader.NimbusJwtReaderFactory;
import com.atlassian.jwt.core.writer.NimbusJwtWriterFactory;
import com.atlassian.jwt.reader.JwtReaderFactory;
import com.atlassian.jwt.writer.JwtWriterFactory;
import java.net.URL;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class JwtAuthConfig {
    private static ACPlayJwtIssuerService acPlayJwtIssuerService = new ACPlayJwtIssuerService();
    private static final PlayJwtRequestExtractor.AddonContextProvider contextProvider = new PlayJwtRequestExtractor.AddonContextProvider(){

        public String get() {
            return JwtAuthConfig.addonContextPath();
        }
    };
    private static final PlayJwtAuthenticator jwtAuthenticator = new PlayJwtAuthenticator((JwtRequestExtractor<Http.Request>)new PlayJwtRequestExtractor(contextProvider), new PlayAuthenticationResultHandler(), JwtAuthConfig.createReaderFactory());
    private static JwtAuthorizationGenerator jwtAuthorizationGenerator = new JwtAuthorizationGenerator(JwtAuthConfig.createWriterFactory());

    private static String addonContextPath() {
        try {
            return new URL((String)AC.baseUrl.get()).getPath();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static JwtReaderFactory createReaderFactory() {
        return new NimbusJwtReaderFactory((JwtIssuerValidator)acPlayJwtIssuerService, (JwtIssuerSharedSecretService)acPlayJwtIssuerService);
    }

    private static JwtWriterFactory createWriterFactory() {
        return new NimbusJwtWriterFactory();
    }

    public static JwtAuthenticator<Http.Request, Http.Response, JwtAuthenticationResult> getJwtAuthenticator() {
        return jwtAuthenticator;
    }

    public static JwtAuthorizationGenerator getJwtAuthorizationGenerator() {
        return jwtAuthorizationGenerator;
    }
}

