/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.play.java.auth.jwt;

import com.atlassian.connect.play.java.AC;
import com.atlassian.connect.play.java.AcHost;
import com.atlassian.connect.play.java.util.Utils;
import com.atlassian.jwt.core.reader.JwtIssuerSharedSecretService;
import com.atlassian.jwt.core.reader.JwtIssuerValidator;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ACPlayJwtIssuerService
implements JwtIssuerSharedSecretService,
JwtIssuerValidator {
    private static final Logger.ALogger LOGGER = Utils.LOGGER;

    public String getSharedSecret(final String issuer) {
        return (String)AC.getAcHost(issuer).map((Function)new Function<AcHost, String>(){

            public String apply(AcHost host) {
                String sharedSecret = host.getSharedSecret();
                if (sharedSecret == null) {
                    LOGGER.warn("The issuer " + issuer + " does not have a shared secret in the database. Please reinstall the addon in this host");
                }
                return sharedSecret;
            }
        }).getOrElse((Supplier)new Supplier<String>(){

            public String get() {
                LOGGER.warn("The issuer " + issuer + " cannot be found in the database. It might be a host that has not registered");
                return null;
            }
        });
    }

    public boolean isValid(String issuer) {
        return this.getSharedSecret(issuer) != null;
    }
}

