/**
 * Stickytable headers for confluence
 */
define("sticky-table-headers/editor", [
    "ajs",
    "jquery",
    "sticky-table-headers/utils",
], function(
    AJS,
    $,
    Utils
) {
    "use strict";

    /**
     * getDefaultConfig - Get default configuration to enable sticky headers in the editor
     *
     * @param {TinymceActiveEditor} editor tinymce active editor instance
     * @return {Object} default configuration for sticky headers to work on the editor
     */
    var getDefaultConfig = function(editor) {
        var defaults = {};
        defaults.objWindow = $(editor.getWin());
        defaults.scrollableArea = defaults.objWindow;
        defaults.objDocument = $(editor.getDoc());
        defaults.objHead = defaults.objDocument.find('head');

        return defaults;
    };

    /**
     * setupTable - Enable sticky tables for a group of table elements
     *
     * @param {HTMLElement|JqueryHtmlElement} table Setup stickyheaders for tables with a defined parameter for valid tables
     * @param {Object} options StickyTableHeaders jquery plugin options
     */
    var setupTable = function(table, options) {
        var editor = AJS.Rte.getEditor();

        if (editor) {
            var defaults = getDefaultConfig(editor);
            var settings = $.extend({}, defaults, options);
            var $validTables = $(table).filter(function() {
                return Utils.isAValidTable(this);
            });

            $validTables.stickyTableHeaders(settings).addClass('stickyTableHeaders');

            Utils.bindHorizontalScrolling($validTables, settings.objWindow);
        }
    };

    /**
     * initialize stickyheaders for all confluence tables
     *
     */
    var initialize = function() {
        var editor = AJS.Rte.getEditor();

        if (editor) {
            var $table = $(editor.getBody()).find(".confluenceTable");

            // the editor structure by default does not have a thead
            Utils.moveHeaderRowsToTHead($table);

            // enable all confluence tables
            setupTable($table);
        }
    };

    return {
        initialize: initialize,
        setupTable: setupTable
    };
});
