/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.status;

import com.atlassian.confluence.plugins.status.StatusColour;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Supplier;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;

public class StatusMacroConfiguration {
    private static final String PARAM_COLOUR = "colour";
    private static final String PARAM_COLOR = "color";
    private static final String PARAM_TITLE = "title";
    private static final String PARAM_SUBTLE = "subtle";
    private Map<String, ? extends Object> params;
    private Supplier<StatusColour> colour = new LazyReference<StatusColour>(){

        protected StatusColour create() throws Exception {
            Maybe colour = StatusMacroConfiguration.this.param(StatusMacroConfiguration.PARAM_COLOUR);
            if (colour.isEmpty()) {
                colour = StatusMacroConfiguration.this.param(StatusMacroConfiguration.PARAM_COLOR);
            }
            if (colour.isDefined()) {
                return StatusColour.fromString((String)colour.get());
            }
            return StatusColour.DEFAULT;
        }
    };
    private Supplier<String> title = new LazyReference<String>(){

        protected String create() throws Exception {
            return this.getTitle().toUpperCase();
        }

        private String getTitle() {
            Maybe title = StatusMacroConfiguration.this.param(StatusMacroConfiguration.PARAM_TITLE);
            if (title.isDefined()) {
                return (String)title.get();
            }
            return StatusMacroConfiguration.this.getColour().name();
        }
    };
    private Supplier<Boolean> subtle = new LazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            Maybe subtle = StatusMacroConfiguration.this.param(StatusMacroConfiguration.PARAM_SUBTLE);
            if (subtle.isDefined()) {
                return BooleanUtils.toBoolean((String)((String)subtle.get()));
            }
            return false;
        }
    };

    public static StatusMacroConfiguration createFor(Map<String, ? extends Object> params) {
        return new StatusMacroConfiguration(params);
    }

    private StatusMacroConfiguration(Map<String, ? extends Object> parameters) {
        this.params = parameters;
    }

    public StatusColour getColour() {
        return (StatusColour)((Object)this.colour.get());
    }

    public boolean isSubtle() {
        return (Boolean)this.subtle.get();
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    private <T> Maybe<T> param(String key) {
        Object value = this.params.get(key);
        if (value != null) {
            Object[] valueArray;
            if (value instanceof Iterable) {
                return Iterables.first((Iterable)((Iterable)value));
            }
            if (value instanceof Object[] && !ArrayUtils.isEmpty((Object[])(valueArray = (Object[])value))) {
                return Option.some((Object)valueArray[0]);
            }
            return Option.some((Object)value);
        }
        return Option.none();
    }
}

