/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.status;

import java.awt.Color;

public enum StatusColour {
    GREY(Color.BLACK, Color.BLACK),
    GREEN(Color.WHITE, Color.decode("#14892C"), "aui-lozenge-success"),
    RED(Color.WHITE, Color.decode("#D04437"), "aui-lozenge-error"),
    YELLOW(Color.decode("#594300"), Color.decode("#594300"), "aui-lozenge-current"),
    BLUE(Color.WHITE, Color.decode("#4A6785"), "aui-lozenge-complete");

    public static StatusColour DEFAULT;
    private final String cssClassName;
    private final Color defaultTextColor;
    private final Color subtleTextColor;

    private StatusColour(Color defaultTextColor, Color subtleTextColor) {
        this(defaultTextColor, subtleTextColor, null);
    }

    private StatusColour(Color defaultTextColor, Color subtleTextColor, String cssClassName) {
        this.defaultTextColor = defaultTextColor;
        this.subtleTextColor = subtleTextColor;
        this.cssClassName = cssClassName;
    }

    public Color forText(boolean subtle) {
        return subtle ? this.subtleTextColor : this.defaultTextColor;
    }

    public String correspondingLozengeCssClass() {
        return this.cssClassName;
    }

    public static StatusColour fromString(String name) {
        try {
            return StatusColour.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return DEFAULT;
        }
    }

    static {
        DEFAULT = GREY;
    }
}

