require([
    'ajs',
    'confluence/meta',
    'confluence/share-page/service/share-page'
], function (AJS,
             Meta,
             SharePage) {
    var heading = Meta.get('content-type') === 'page'
        ? AJS.I18n.getText('share.dialog.heading.page')
        : AJS.I18n.getText('share.dialog.heading.blogpost');
    var notePlaceholder = Meta.get('content-type') === 'page'
        ? AJS.I18n.getText('share.dialog.message.placeholder.page')
        : AJS.I18n.getText('share.dialog.message.placeholder.blogpost');
    AJS.toInit(function ($) {
        var selector = "#shareContentLink";
        var $trigger = $(selector);
        SharePage.initDialog(selector, "shareContentPopup", {}, {
            heading: heading,
            notePlaceholder: notePlaceholder,
            link: function () {
                return $('link[rel="shortlink"]').prop('href');
            },
            entityId: function () {
                return Meta.get('page-id');
            },
            restriction: function() {
                return require('confluence/share-page/fetch/content-restrictions')(Meta.get('content-id'))
                    .pipe(function (response) {
                        var isRestricted = response.read.restrictions.user.size
                            || response.read.restrictions.group.size
                            || response.update.restrictions.user.size
                            || response.update.restrictions.group.size;
                        var restrictionWarning = {};
                        if (isRestricted) {
                            restrictionWarning.type = "restrict";
                            restrictionWarning.message = AJS.I18n.getText("share.restriction.page.restrict");
                        }
                        return restrictionWarning;

                    });
            },
            copyOption: 'share',
            shareType: 'view',
            contentType: Meta.get('content-type'),
            errorText: AJS.I18n.getText('share.dialog.error'),
            beforeLoad: function () {
                $trigger.find('.aui-icon').css('visibility', 'hidden'); // hide current icon
                $trigger.parent().spin({left: '10px'});
            },
            afterLoad: function () {
                $trigger.find('.aui-icon').css('visibility', 'visible'); // show current icon
                $trigger.parent().spinStop();
            },
            onHide: function () {
                $(".dashboard-actions .explanation").hide();
            }
        });
    });
});