define('confluence/share-page/service/share-page', [
    'ajs',
    'wrm',
    'jquery'
], function (AJS,
             WRM,
             $) {
    var CLICK_EVENT = 'click.share-page';
    return {
        /**
         * Main initialisation function for the dialog.
         * @param selector      Selector for the trigger element
         * @param identifier    Identifier of the Corresponding inline dialog
         * @param options       Any additional options to pass to the Inline Dialog
         * @param parameters    Parameters control how the dialog behaves and what values
         *                      are presented to the user, since the share dialog is used a across features.
         * @param {string} parameters.heading         Heading text to use in the dialog
         * @param {string} parameters.notePlaceholder Placeholder text to use in the note (message) textarea.
         * @param {string} parameters.errorText       Message to display if there is an error with the share.
         * @param {function} parameters.link          A function that could return the link to this item, or a promise
         *                                                with the link to this item, to use in the "Link" portion of the dialog.
         * @param {function} parameters.entityId      A function that should return the id of the item to the be shared.
         * @param {string} parameters.copyOption      The option to use for the copy (text) of this dialog.
         *                                                Two types are supported: 'share', and 'invite'
         *                                                Depending on the selection different text will be used in the dialog
         * @param {string} parameters.shareType       Separate from contentType, shareType specifies the type of share we are making which
         *                                                informs the behavior and analytics events of the dialog.
         *                                                Possible types are 'view','edit','attachment','question'
         * @param {string} parameters.contentType     The content type that is being shared, could be page, blogpost, attachment, question
         *                                                This is separate from the shareType
         * @param {function} parameters.beforeLoad    Function that will run before the dialog resources are loaded.
         * @param {function} parameters.afterLoad     Function that will run after the dialog resources are loaded.
         *                                                Note that at this point none of the dialog is setup. Use onShow
         *                                                if you need access to the dialog
         * @param {function} parameters.onShow        Function that will run after the dialog is shown.
         * @param {function} parameters.onHide        Function that will run before the dialog is hidden.
         *
         */
        initDialog: function (selector, identifier, options, parameters) {
            var $trigger = $(selector);
            if ($trigger.length) {
                $trigger.off(CLICK_EVENT).on(CLICK_EVENT, function (e) {
                    $trigger.off(CLICK_EVENT);
                    parameters.beforeLoad && typeof parameters.beforeLoad === 'function' && parameters.beforeLoad();
                    WRM.require(['wrc!share-page-async-loader']).done(function () {
                        parameters.afterLoad && typeof parameters.afterLoad === 'function' && parameters.afterLoad();
                        require('confluence/share-page/dialog-async-loader')(selector, identifier, $.extend(false, {
                            hideCallback: function () {
                                parameters.onHide && typeof parameters.onHide === 'function' && parameters.onHide();
                            },
                            width: 250,
                            hideDelay: 36e5
                        }, options), parameters);
                        $trigger.click();
                    });
                    e.preventDefault();
                    return false;
                });
            }
        }
    };
});

