require([
    'ajs',
    'confluence/meta',
    'confluence/share-page/service/share-page'
], function (AJS,
             Meta,
             SharePage) {
    AJS.toInit(function ($) {
        var selector = ".cq-share-button";
        var $shareButton = $(selector);
        SharePage.initDialog(selector, "shareContentPopup", {offsetX: -110}, {
            heading: AJS.I18n.getText('share.dialog.heading.question'),
            notePlaceholder: AJS.I18n.getText('share.dialog.message.placeholder.question'),
            link: function () {
                return window.location;
            },
            entityId: function () {
                // content-id is set to the current answer, while page-id is the id of the question
                return Meta.get('pageId');
            },
            copyOption: 'share',
            shareType: 'custom',
            contentType: Meta.get('content-type'),
            errorText: AJS.I18n.getText('share.dialog.error'),
            beforeLoad: function () {
                $shareButton.find('.aui-icon').css('visibility', 'hidden'); // hide current icon
                $shareButton.spin({left: '0px'});
            },
            afterLoad: function () {
                $shareButton.find('.aui-icon').css('visibility', 'visible'); // show current icon
                $shareButton.spinStop();
            }
        });
    });
});