/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.query.v2search;

import com.atlassian.confluence.plugins.search.query.QueryFactory;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;

public class SiteTextSearchQuery
implements SearchQuery {
    private static final Pattern QUERY_STRING_SYNTAX_REGEX = Pattern.compile("(?<!\\\\)[\\*\"\\(\\):~^+-]|(\\s|^)AND\\s|(\\s|^)OR\\s|(\\s|^)NOT\\s");
    public static final String KEY = "siteSearch";
    private String textQuery;
    private QueryFactory.Boost shouldBoost;

    @Deprecated
    public SiteTextSearchQuery(String text, QueryFactory.Boost shouldBoost) {
        this.textQuery = text;
        this.shouldBoost = shouldBoost;
    }

    public SiteTextSearchQuery(String text) {
        this.textQuery = text;
        this.shouldBoost = QueryFactory.Boost.NO_BOOST;
    }

    public String getKey() {
        return KEY;
    }

    public List getParameters() {
        return ImmutableList.of((Object)this.textQuery);
    }

    public String getTextQuery() {
        return this.textQuery;
    }

    public QueryFactory.Boost shouldBoost() {
        return this.shouldBoost;
    }

    public static boolean isQueryStringSyntax(String queryString) {
        return QUERY_STRING_SYNTAX_REGEX.matcher(queryString).find();
    }

    public String toString() {
        return Objects.toStringHelper(SiteTextSearchQuery.class).add("textQuery", (Object)this.textQuery).add("shouldBoost", (Object)this.shouldBoost).toString();
    }
}

