/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.boosting;

import com.atlassian.confluence.plugin.CompositeModuleDescriptorPredicate;
import com.atlassian.confluence.plugin.ModuleDescriptorCache;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="moduleDescriptorCacheFactory")
public class ModuleDescriptorCacheFactory {
    private final PluginAccessor pluginAccessor;
    private final PluginEventManager pluginEventManager;

    @Autowired
    public ModuleDescriptorCacheFactory(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginEventManager pluginEventManager) {
        this.pluginAccessor = pluginAccessor;
        this.pluginEventManager = pluginEventManager;
    }

    public <T extends ModuleDescriptor<?>> ModuleDescriptorCache<T> create(Class<T> moduleDescriptorClass) {
        ModuleDescriptorCache cache = new ModuleDescriptorCache(moduleDescriptorClass);
        this.pluginEventManager.register((Object)cache);
        cache.initialize(() -> this.pluginAccessor.getEnabledModuleDescriptorsByClass(moduleDescriptorClass));
        return cache;
    }

    public <T extends ModuleDescriptor<?>> ModuleDescriptorCache<T> create(Class<T> moduleDescriptorClass, ModuleDescriptorPredicate<T> moduleDescriptorPredicate) {
        ModuleDescriptorCache cache = new ModuleDescriptorCache(moduleDescriptorClass, moduleDescriptorPredicate);
        this.pluginEventManager.register((Object)cache);
        cache.initialize(() -> {
            EnabledModulePredicate enabledModulePredicate = new EnabledModulePredicate();
            return this.pluginAccessor.getModuleDescriptors((ModuleDescriptorPredicate)new CompositeModuleDescriptorPredicate(new ModuleDescriptorPredicate[]{enabledModulePredicate, moduleDescriptorPredicate}));
        });
        return cache;
    }
}

