/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.actions;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.plugins.search.actions.SearchResultHighlights;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="cqlSearcher")
public class CQLSearcher {
    private static final Function<SearchResult, SearchResult> HTML_PREP_CQL_SEARCH_RESULT = result -> {
        Preconditions.checkNotNull((Object)result);
        String title = result.getTitle();
        String highlights = result.getExcerpt();
        String htmlHighlights = StringUtils.replaceEach((String)highlights, (String[])SearchResultHighlights.API_HIGHLIGHT, (String[])SearchResultHighlights.HTML_HIGHLIGHT);
        String htmlTitle = StringUtils.replaceEach((String)title, (String[])SearchResultHighlights.API_HIGHLIGHT, (String[])SearchResultHighlights.HTML_HIGHLIGHT);
        return SearchResult.builder((Object)result.getEntity()).title(htmlTitle).bodyExcerpt(htmlHighlights).entityParentContainer(result.getResultParentContainer()).resultGlobalContainer(result.getResultGlobalContainer()).iconCssClass(result.getIconCssClass()).url(result.getUrl()).friendlyLastModified(result.getFriendlyLastModified()).lastModified(result.getLastModified()).build();
    };
    private CQLSearchService searchService;

    @Autowired
    public CQLSearcher(@ComponentImport CQLSearchService searchService) {
        this.searchService = searchService;
    }

    @VisibleForTesting
    SearchPageResponse<SearchResult> getCqlSearchResults(String cql, SearchQueryParameters searchQuery) throws BadRequestException {
        if (Strings.isNullOrEmpty((String)cql)) {
            return SearchPageResponse.builder().build();
        }
        SearchOptions searchOptions = SearchOptions.builder().excerptStrategy(SearchOptions.Excerpt.HIGHLIGHT).includeArchivedSpaces(searchQuery.isIncludeArchivedSpaces()).fireSearchPerformed(true).build();
        SearchPageResponse cqlSearchResults = this.searchService.search(cql, searchOptions, (PageRequest)new SimplePageRequest(searchQuery.getStartIndex(), searchQuery.getPageSize()), new Expansion[0]);
        List results = cqlSearchResults.getResults().stream().map(HTML_PREP_CQL_SEARCH_RESULT).collect(Collectors.toList());
        return SearchPageResponse.builder().result(results).totalSize(cqlSearchResults.totalSize()).searchDuration(cqlSearchResults.getSearchDuration()).build();
    }
}

