/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.pagetree;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageHierarchyExtractor
implements Extractor {
    private static final Logger log = LoggerFactory.getLogger(PageHierarchyExtractor.class);
    public static final String ANCESTORS_KEY = "ancestorIds";

    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        Attachment attachment;
        ContentEntityObject ceo;
        Page page = null;
        if (searchable instanceof Page) {
            page = (Page)searchable;
        } else if (searchable instanceof Attachment && (ceo = (attachment = (Attachment)searchable).getContent()) instanceof Page) {
            page = (Page)ceo;
        }
        if (page != null) {
            document.add((IndexableField)new StringField(ANCESTORS_KEY, String.valueOf(page.getId()), Field.Store.YES));
            for (Page element : page.getAncestors()) {
                document.add((IndexableField)new StringField(ANCESTORS_KEY, String.valueOf(element.getId()), Field.Store.YES));
            }
            if (log.isDebugEnabled()) {
                log.debug("searchable:  " + searchable + " page: " + page.getTitle() + " ancestors: " + page.getAncestors());
            }
        }
    }
}

