/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.gadgets.metadata;

import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cache.CacheStatisticsManager;
import com.atlassian.confluence.macro.browser.MacroMetadataProvider;
import com.atlassian.confluence.macro.browser.beans.MacroMetadata;
import com.atlassian.confluence.macro.browser.beans.MacroSummary;
import com.atlassian.confluence.plugins.gadgets.events.GadgetInstalledEvent;
import com.atlassian.confluence.plugins.gadgets.events.GadgetUninstalledEvent;
import com.atlassian.confluence.plugins.gadgets.metadata.CachedMetadata;
import com.atlassian.confluence.plugins.gadgets.metadata.GadgetCacheFlusher;
import com.atlassian.confluence.plugins.gadgets.metadata.GadgetUsageTracker;
import com.atlassian.confluence.plugins.gadgets.metadata.GadgetsMacroMetadataProvider;
import com.atlassian.confluence.plugins.gadgets.requestcontext.RequestContextBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.GadgetSpecProvider;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpecStore;
import com.atlassian.gadgets.directory.spi.SubscribedGadgetFeedStore;
import com.atlassian.gadgets.feed.GadgetFeedReaderFactory;
import com.atlassian.gadgets.spec.GadgetSpecFactory;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.JvmCacheSettingsBuilder;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class CachingGadgetsMacroMetadataProvider
implements MacroMetadataProvider,
InitializingBean,
DisposableBean {
    @VisibleForTesting
    static final String CACHE_NAME = CachingGadgetsMacroMetadataProvider.class.getName();
    @VisibleForTesting
    static final String CACHE_KEY = "Key";
    private static final Logger log = LoggerFactory.getLogger(CachingGadgetsMacroMetadataProvider.class);
    private final GadgetCacheFlusher gadgetCacheFlusher;
    private final GadgetsMacroMetadataProvider delegateProvider;
    private final Supplier<JvmCache<String, CachedMetadata>> cache;

    public CachingGadgetsMacroMetadataProvider(CacheManager cacheManager, VCacheFactory cacheFactory, CacheStatisticsManager cacheStatisticsManager, GadgetSpecProvider gadgetSpecProvider, ExternalGadgetSpecStore gadgetStore, SubscribedGadgetFeedStore feedStore, GadgetFeedReaderFactory gadgetFeedReaderFactory, GadgetSpecFactory gadgetSpecFactory, RequestContextBuilder requestContextBuilder, I18nResolver resolver, EventPublisher eventPublisher, GadgetUsageTracker gadgetUsageTracker) {
        this(cacheFactory, new GadgetCacheFlusher(cacheManager, gadgetUsageTracker, cacheStatisticsManager, eventPublisher), new GadgetsMacroMetadataProvider(gadgetSpecProvider, gadgetStore, feedStore, gadgetFeedReaderFactory, gadgetSpecFactory, requestContextBuilder, resolver, eventPublisher));
    }

    @VisibleForTesting
    CachingGadgetsMacroMetadataProvider(VCacheFactory cacheFactory, GadgetCacheFlusher gadgetCacheFlusher, GadgetsMacroMetadataProvider delegateProvider) {
        this.delegateProvider = (GadgetsMacroMetadataProvider)Preconditions.checkNotNull((Object)delegateProvider);
        this.gadgetCacheFlusher = (GadgetCacheFlusher)Preconditions.checkNotNull((Object)gadgetCacheFlusher);
        this.cache = Lazy.supplier(() -> cacheFactory.getJvmCache(CACHE_NAME, new JvmCacheSettingsBuilder().maxEntries(1).build()));
    }

    public void afterPropertiesSet() throws Exception {
        this.cache.get();
    }

    public void destroy() throws Exception {
        this.clearMacroMetadataCache();
    }

    public Collection<MacroMetadata> getData() {
        Set<URI> currentGadgetUris;
        CachedMetadata cachedMetadata = (CachedMetadata)((JvmCache)this.cache.get()).get((Object)CACHE_KEY, () -> this.loadOnMiss());
        if (cachedMetadata.matchesGadgetUris(currentGadgetUris = this.getGadgetUris())) {
            log.debug("Cached macro metadata matches current set of {} gadget URIs, returning cached macro metadata", (Object)currentGadgetUris.size());
            return cachedMetadata.getMacroMetadata();
        }
        log.debug("Cached macro metadata set of {} gadget URIs does not match current set of {} gadget URIs", (Object)cachedMetadata.getGadgetUris().size(), (Object)currentGadgetUris.size());
        ((JvmCache)this.cache.get()).removeAll();
        return ((CachedMetadata)((JvmCache)this.cache.get()).get((Object)CACHE_KEY, () -> this.loadOnMiss())).getMacroMetadata();
    }

    public Collection<MacroSummary> getSummaries() {
        return GadgetsMacroMetadataProvider.getSummaries(this.getData());
    }

    public MacroMetadata getByMacroName(String macroName) {
        return this.getByMacroNameAndId(macroName, null);
    }

    public MacroMetadata getByMacroNameAndId(String macroName, String alternateId) {
        return GadgetsMacroMetadataProvider.getByMacroNameAndId(macroName, alternateId, this.getData());
    }

    private CachedMetadata loadOnMiss() {
        Set<URI> gadgetUris = this.delegateProvider.getGadgetUris();
        log.debug("Starting fetch and assembly of gadgets macro metadata for {} gadget URIs", (Object)gadgetUris.size());
        long start = System.currentTimeMillis();
        Collection<MacroMetadata> macroMetadata = this.delegateProvider.getMacroMetadata(gadgetUris);
        long end = System.currentTimeMillis();
        log.debug("Gadgets macro metadata assembly for {} gadget URIs took {} ms.", (Object)gadgetUris.size(), (Object)(end - start));
        this.gadgetCacheFlusher.requestGadgetsCacheFlush();
        return new CachedMetadata((Set<URI>)ImmutableSet.copyOf(gadgetUris), (Collection<MacroMetadata>)ImmutableList.copyOf(macroMetadata));
    }

    private Set<URI> getGadgetUris() {
        log.trace("Fetching gadget URIs first");
        long start = System.currentTimeMillis();
        Set<URI> gadgetUris = this.delegateProvider.getGadgetUris();
        long end = System.currentTimeMillis();
        log.trace("Fetched {} gadget URIs in {}ms", (Object)gadgetUris.size(), (Object)(end - start));
        return gadgetUris;
    }

    private void clearMacroMetadataCache() {
        log.debug("Clearing gadgets macro metadata cache");
        ((JvmCache)this.cache.get()).removeAll();
    }

    @EventListener
    public void gadgetInstalled(GadgetInstalledEvent event) {
        log.debug("Gadget installed, uri={}", (Object)event.getGadgetUri());
        this.clearMacroMetadataCache();
    }

    @EventListener
    public void gadgetUninstalled(GadgetUninstalledEvent event) {
        log.debug("Gadget uninstalled, uri={}", (Object)event.getGadgetUri());
        this.clearMacroMetadataCache();
    }

    @EventListener
    public void pluginUninstalled(PluginUninstalledEvent event) {
        log.debug("Plugin {} uninstalled, clearing gadgets metadata cache since we assume it's now stale", (Object)event.getPlugin());
        this.clearMacroMetadataCache();
    }

    @EventListener
    public void pluginUpgraded(PluginUpgradedEvent event) {
        log.debug("Plugin {} upgraded, clearing gadgets metadata cache since we assume it's now stale", (Object)event.getPlugin());
        this.clearMacroMetadataCache();
    }
}

