define("confluence-user-profile/avatar-picker/upload-interceptor", [
    "jquery",
    "underscore"
],
function(
    $,
    _
) {
    "use strict";

    function UploadInterceptor(el, opts) {
        return this.init.apply(this, arguments);
    }

    UploadInterceptor.prototype.defaults = {
        replacementEl: undefined,
        clientFileHandler: null
    };

    UploadInterceptor.prototype.init = function(el, opts) {
        _.bindAll(this, 'onSelectFile', 'onReplacementClick');

        this._$el = $(el);
        this.options = _.extend({}, this.defaults, opts);

        this._$el.on('change', this.onSelectFile);

        if (this.options.replacementEl) {
            this._$replacement = $(this.options.replacementEl);
            this._$el.hide();
            this._$replacement.on('click', this.onReplacementClick);
        }
    };

    UploadInterceptor.prototype.onSelectFile = function(e) {
        if ($(e.target).val() && this.options.clientFileHandler) {
            this.options.clientFileHandler.handleFiles(e.target.files, this._$el);
        }
    };

    UploadInterceptor.prototype.onReplacementClick = function(e) {
        e.preventDefault();
        this._$el.click();
    };

    UploadInterceptor.prototype.destroy = function() {
        this._$el.off('change', this.onSelectFile);
        this._$replacement.off('click', this.onReplacementClick);
    };

    return UploadInterceptor;
});
