/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.actions;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.searchfilter.ChainedSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ContentPermissionsSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.InSpaceSearchFilter;
import com.atlassian.confluence.security.access.annotations.RequiresAnyConfluenceAccess;
import com.atlassian.confluence.spaces.actions.ViewSpaceSummaryAction;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Qualifier;

@RequiresAnyConfluenceAccess
public class PagesCollectorAction
extends ViewSpaceSummaryAction {
    private SearchManager searchManager;
    private boolean showBlankExperience;
    private boolean hasCreatePermission;
    private String createPageLink;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        if (this.space != null) {
            this.showBlankExperience = this.determineShowBlankExperience();
            this.createPageLink = "/pages/createpage.action?spaceKey=" + GeneralUtil.urlEncode((String)this.space.getKey()) + this.getFromPageParam();
            this.hasCreatePermission = this.permissionManager.hasCreatePermission((User)AuthenticatedUserThreadLocal.get(), (Object)this.space, Page.class);
        }
        return super.execute();
    }

    public boolean getShowBlankExperience() {
        return this.showBlankExperience;
    }

    public boolean getHasCreatePermission() {
        return this.hasCreatePermission;
    }

    public String getCreatePageLink() {
        return this.createPageLink;
    }

    public String getRoot() {
        return this.space.getHomePage() != null ? "@home" : "@none";
    }

    private boolean determineShowBlankExperience() {
        if (this.space == null) {
            return false;
        }
        HashSet spaceKeys = Sets.newHashSet((Object[])new String[]{this.space.getKey()});
        InSpaceSearchFilter inSpaceSearchFilter = new InSpaceSearchFilter((Set)spaceKeys);
        ContentPermissionsSearchFilter instance = ContentPermissionsSearchFilter.getInstance();
        ChainedSearchFilter filter = new ChainedSearchFilter(new SearchFilter[]{inSpaceSearchFilter, instance});
        ContentSearch search = new ContentSearch((SearchQuery)new ContentTypeQuery(ContentTypeEnum.PAGE), null, (SearchFilter)filter, null);
        try {
            SearchResults results = this.searchManager.search((ISearch)search);
            return results.size() <= 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getFromPageParam() {
        Page homePage = this.space.getHomePage();
        return homePage == null ? "" : "&fromPageId=" + homePage.getIdAsString();
    }

    public void setContentEntityManager(@Qualifier(value="ContentEntityManager") ContentEntityManager contentEntityManager) {
        super.setContentEntityManager(contentEntityManager);
    }

    public void setSearchManager(SearchManager searchManager) {
        this.searchManager = searchManager;
    }
}

