package com.atlassian.confluence.plugins.documentation;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.createcontent.api.events.SpaceBlueprintHomePageCreateEvent;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.api.EventListener;

import java.util.ArrayList;
import java.util.List;

public class CreateSpaceHomePageEventListener
{
    private static final String DOCUMENTATION_SPACE_COMPLETE_KEY = "com.atlassian.confluence.plugins.confluence-space-blueprints:documentation-space-blueprint";
    private final LabelManager labelManager;
    private final PageManager pageManager;
    private final ConfluenceIndexManager indexManager;

    public CreateSpaceHomePageEventListener(LabelManager labelManager, PageManager pageManager, ConfluenceIndexManager indexManager)
    {
        this.labelManager = labelManager;
        this.pageManager = pageManager;
        this.indexManager = indexManager;
    }

    @EventListener
    public void onSpaceHomePageCreate(SpaceBlueprintHomePageCreateEvent event)
    {
        if (!DOCUMENTATION_SPACE_COMPLETE_KEY.equals(event.getSpaceBlueprint().getModuleCompleteKey()))
        {
            return;
        }

        List<Label> labels = new ArrayList<Label>();
        labels.add(new Label("featured"));
        labels.add(new Label("documentation-space-sample"));

        // add labels to the pages
        Space space = event.getSpace();
        Long homePageId = space.getHomePage().getId();
        List<Page> pages = pageManager.getPages(space, false);
        for (Page page : pages)
        {
            if (page.getId() != homePageId)
            {
                for (Label label: labels)
                {
                    labelManager.addLabel(page, label);
                }
            }
        }

        indexManager.flushQueue(ConfluenceIndexManager.IndexQueueFlushMode.ENTIRE_QUEUE);
    }
}
