package com.atlassian.confluence.plugins.documentation;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugins.createcontent.api.events.SpaceBlueprintCreateEvent;
import com.atlassian.confluence.plugins.ia.SidebarLinkCategory;
import com.atlassian.confluence.plugins.ia.rest.SidebarLinkBean;
import com.atlassian.confluence.plugins.ia.service.SidebarLinkService;
import com.atlassian.confluence.plugins.ia.service.SidebarService;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.event.api.EventListener;

import java.util.Map;

public class CreateSpaceEventListener
{
    private final SidebarService sidebarService;
    private final SidebarLinkService sidebarLinkService;
    private I18NBeanFactory i18NBeanFactory;
    private LocaleManager localeManager;
    private static final String DOCUMENTATION_SPACE_COMPLETE_KEY = "com.atlassian.confluence.plugins.confluence-space-blueprints:documentation-space-blueprint";

    public CreateSpaceEventListener(SidebarService sidebarService, SidebarLinkService sidebarLinkService, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager)
    {
        this.sidebarService = sidebarService;
        this.sidebarLinkService = sidebarLinkService;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
    }

    @EventListener
    public void onSpaceBlueprintCreate(SpaceBlueprintCreateEvent event) throws NotPermittedException
    {
        if (!event.getSpaceBlueprint().getModuleCompleteKey().equals(DOCUMENTATION_SPACE_COMPLETE_KEY))
            return;

        // add our spacekey to the context so we can shove it into the homepage template
        Map<String, Object> context = event.getContext();
        Space space = event.getSpace();
        context.put("spaceKey", space.getKey());

        // create a var for the i18n'ed link to the readme page
        I18NBean i18NBean = i18NBeanFactory.getI18NBean(localeManager.getLocale(AuthenticatedUserThreadLocal.get()));
        String pageTitle = i18NBean.getText("confluence.blueprints.space.documentation.making-a-template.name");
        context.put("makingATemplateLink", "<ri:page ri:content-title=\"" + pageTitle + "\" />");

        String spaceKey = space.getKey();
        // this space wants a minimalist sidebar
        sidebarService.setOption(spaceKey, SidebarService.NAV_TYPE_OPTION, SidebarService.PAGE_TREE_NAV_TYPE);
        sidebarService.setOption(spaceKey, SidebarService.QUICK_LINKS_STATE_OPTION, SidebarService.QUICK_LINKS_HIDE_STATE);
        for (SidebarLinkBean link : sidebarLinkService.getLinksForSpace(SidebarLinkCategory.MAIN, spaceKey, false))
        {
            sidebarLinkService.hide(spaceKey, link.getId());
        }
    }
}
