package com.atlassian.confluence.plugins.retrospectives;

import com.atlassian.confluence.plugins.SoftwareBlueprintsContextProviderHelper;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.AbstractBlueprintContextProvider;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContext;

public class RetrospectivesIndexContextProvider extends AbstractBlueprintContextProvider {

    private SoftwareBlueprintsContextProviderHelper helper;

    @Override
    protected BlueprintContext updateBlueprintContext(BlueprintContext context) {
        String buttonLabel = helper.getText("retrospectives.blueprint.index.template.button.label");
        context.put("createFromTemplateMacro", helper.getCreateFromTemplateMacro(context, buttonLabel,
                RetrospectivesContextProvider.TEMPLATE_PROVIDER_PLUGIN_KEY));
        return context;
    }

    public void setHelper(SoftwareBlueprintsContextProviderHelper helper) {
        this.helper = helper;
    }
}
