package com.atlassian.confluence.plugins.retrospectives;

import com.atlassian.confluence.plugins.SoftwareBlueprintsContextProviderHelper;
import com.atlassian.confluence.plugins.common.event.SoftwareBPAnalyticEventUtils;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.AbstractBlueprintContextProvider;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RetrospectivesContextProvider extends AbstractBlueprintContextProvider {
    public static final String TEMPLATE_PROVIDER_PLUGIN_KEY =
            "com.atlassian.confluence.plugins.confluence-software-blueprints:retrospective-resources";

    private static final String USER_LIST_TEMPLATE = "Confluence.Blueprints.Common.userList.soy";
    private static final String USERS_TEMPLATE = "Confluence.Blueprints.Common.users.soy";
    private static final String USER_TABLE_TEMPLATE = "Confluence.Blueprints.Common.userTable.soy";
    private static final String USERNAME_KEY = "names";

    private final SoftwareBlueprintsContextProviderHelper helper;

    public RetrospectivesContextProvider(SoftwareBlueprintsContextProviderHelper helper) {
        this.helper = helper;
    }

    @Override
    protected BlueprintContext updateBlueprintContext(BlueprintContext context) {
        String participantParam = (String) context.get("retro-participants");
        Map<String, Object> soyContext = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(participantParam)) {
            soyContext.put(USERNAME_KEY, participantParam.split(","));
            context.put("participants", helper.renderFromSoy(TEMPLATE_PROVIDER_PLUGIN_KEY, USERS_TEMPLATE, soyContext));
            context.put("participantList", helper.renderFromSoy(TEMPLATE_PROVIDER_PLUGIN_KEY, USER_LIST_TEMPLATE, soyContext));
            context.put("participantTable", helper.renderFromSoy(TEMPLATE_PROVIDER_PLUGIN_KEY, USER_TABLE_TEMPLATE, soyContext));
        }
        context.setTitle((String) context.get("retro-title"));
        context.put("currentDate", helper.serverFormatDate(new Date())); //for old edited blueprint templates
        context.put("currentDateLozenge", helper.createStorageFormatForToday());
        doAnalytic(participantParam);
        return context;
    }

    private void doAnalytic(String participants) {
        String username = AuthenticatedUserThreadLocal.getUsername();
        if (username != null && !username.equals(participants)) {
            helper.publishAnalyticEvent(SoftwareBPAnalyticEventUtils.RETROSPECTIVE_UPDATE_PARTICIPANTS_EVENT_NAME);
        }
        helper.publishAnalyticEvent(SoftwareBPAnalyticEventUtils.RETROSPECTIVE_CREATE_EVENT_NAME);
    }
}
