package com.atlassian.confluence.plugins.jirareports;

import com.atlassian.confluence.plugins.SoftwareBlueprintsContextProviderHelper;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.AbstractBlueprintContextProvider;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContext;
import com.atlassian.core.util.XMLUtils;
import com.google.common.collect.Maps;

import java.util.HashMap;

public class JiraReportsIndexContextProvider extends AbstractBlueprintContextProvider {
    private SoftwareBlueprintsContextProviderHelper helper;
    private static final String SOY_CREATE_FROM_TEMPLATE_MACRO = "Confluence.Blueprints.JiraReports.Template.createFromTemplateMacro.soy";

    @Override
    protected BlueprintContext updateBlueprintContext(BlueprintContext context) {
        String spaceKey = XMLUtils.escape(context.getSpaceKey());
        String blueprintKey = XMLUtils.escape(context.getBlueprintModuleCompleteKey().getCompleteKey());

        context.put("createFromTemplateMacro", getCreateFromTemplateMacro(blueprintKey, spaceKey));

        return context;
    }

    private String getCreateFromTemplateMacro(String blueprintKey, String spaceKey) {
        HashMap<String, Object> templateContext = Maps.newHashMap();
        templateContext.put("blueprintKey", blueprintKey);
        templateContext.put("spaceKey", spaceKey);
        return helper.renderFromSoy(SoftwareBlueprintsContextProviderHelper.PLUGIN_KEY, SOY_CREATE_FROM_TEMPLATE_MACRO, templateContext);
    }

    public void setHelper(SoftwareBlueprintsContextProviderHelper helper) {
        this.helper = helper;
    }
}
