/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.beans.RemoteUser;
import com.atlassian.confluence.rpc.soap.beans.RemoteUserInformation;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserContentManager;
import com.atlassian.confluence.util.ProfilePicture;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.search.page.Pager;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class UsersSoapService {
    UserAccessor userAccessor;
    SpacePermissionManager spacePermissionManager;
    PermissionManager permissionManager;
    SoapServiceHelper soapServiceHelper;
    SpaceManager spaceManager;
    PersonalInformationManager personalInformationManager;
    AttachmentManager attachmentManager;
    private static final Logger LOG = LoggerFactory.getLogger(UsersSoapService.class);
    private UserContentManager userContentManager;

    public void setUserContentManager(UserContentManager userContentManager) {
        this.userContentManager = userContentManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public RemoteUser getUser(String username) throws RemoteException {
        return new RemoteUser(this.retrieveUser(username));
    }

    private User retrieveUser(String username) throws RemoteException {
        User user = this.userAccessor.getUser(username);
        if (user == null) {
            throw new RemoteException("No user with username " + username + " found.");
        }
        return user;
    }

    private void checkUserCanEditObject(Object target) throws NotPermittedException {
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(currentUser, Permission.EDIT, target)) {
            throw new NotPermittedException("You are not permitted to access " + target);
        }
    }

    public boolean addUser(RemoteUser user, String password) throws RemoteException {
        if (user == null) {
            throw new RemoteException("Can't add null user.");
        }
        if (StringUtils.isBlank((String)user.getName())) {
            throw new RemoteException("Can't add user with null or blank username.");
        }
        if (StringUtils.isBlank((String)user.getFullname())) {
            throw new RemoteException("Can't add user with null or blank fullname.");
        }
        if (StringUtils.isBlank((String)user.getEmail())) {
            throw new RemoteException("Can't add user with null or blank email address.");
        }
        if (!user.getName().equals(user.getName().toLowerCase())) {
            throw new RemoteException("A user name must be in lower case.");
        }
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasCreatePermission(currentUser, PermissionManager.TARGET_APPLICATION, User.class)) {
            throw new NotPermittedException("You do not have permissions to add the user " + user.getName() + ".");
        }
        try {
            this.userAccessor.addUser(user.getName(), password, user.getEmail(), user.getFullname(), new String[]{"confluence-users"});
        }
        catch (InfrastructureException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            throw new RemoteException("Could not create new user '" + user.getName() + "': " + e.getMessage(), e.getCause());
        }
        return true;
    }

    public boolean removeUser(String username) throws RemoteException {
        User user = this.retrieveUser(username);
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(currentUser, Permission.REMOVE, (Object)user)) {
            throw new NotPermittedException("You do not have permissions to remove the user " + username);
        }
        if (this.userContentManager.hasAuthoredContent(user)) {
            throw new RemoteException("Cannot remove user because they have authoured content");
        }
        Space personalSpace = this.spaceManager.getPersonalSpace(user);
        if (personalSpace != null) {
            this.spaceManager.removeSpace(personalSpace);
        }
        try {
            this.userAccessor.removeUser(user);
        }
        catch (InfrastructureException e) {
            return false;
        }
        return true;
    }

    public boolean editUser(RemoteUser remoteUser) throws NotPermittedException, RemoteException {
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        User givenUser = this.retrieveUser(remoteUser.getName());
        boolean updateRequired = false;
        if (!this.permissionManager.hasPermission(currentUser, Permission.EDIT, (Object)givenUser)) {
            throw new NotPermittedException("You do not have permissions to edit user: " + remoteUser.getName());
        }
        DefaultUser userTemplate = new DefaultUser(givenUser);
        if (!givenUser.getFullName().equals(remoteUser.getFullname())) {
            updateRequired = true;
            userTemplate.setFullName(remoteUser.getFullname());
        }
        if (!givenUser.getEmail().equals(remoteUser.getEmail())) {
            updateRequired = true;
            userTemplate.setEmail(remoteUser.getEmail());
        }
        if (updateRequired) {
            this.userAccessor.saveUser((User)userTemplate);
        }
        return true;
    }

    public String[] getUserGroups(String username) throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        User user = this.retrieveUser(username);
        Pager groups = this.userAccessor.getGroups(user);
        ArrayList<String> groupsOfUser = new ArrayList<String>();
        for (Group group : groups) {
            groupsOfUser.add(group.getName());
        }
        return groupsOfUser.toArray(new String[groupsOfUser.size()]);
    }

    public boolean addUserToGroup(String username, String groupname) throws RemoteException {
        User user = this.retrieveUser(username);
        Group group = this.userAccessor.getGroup(groupname);
        if (group == null) {
            throw new RemoteException("The group specified does not exist.");
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.EDIT, (Object)group)) {
            throw new NotPermittedException("You do not have permissions to add the user " + username + " to the following group " + groupname);
        }
        this.userAccessor.addMembership(group, user);
        return this.userAccessor.hasMembership(group, user);
    }

    public boolean removeUserFromGroup(String username, String groupname) throws RemoteException {
        User user = this.retrieveUser(username);
        Group group = this.userAccessor.getGroup(groupname);
        if (group == null) {
            throw new RemoteException("The group specified does not exist.");
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.EDIT, (Object)group)) {
            throw new NotPermittedException("You do not have permissions to remove the user " + username + " from the following group " + groupname);
        }
        this.userAccessor.removeMembership(group, user);
        return !this.userAccessor.hasMembership(group, user);
    }

    public boolean addGroup(String groupname) throws RemoteException {
        if (StringUtils.isBlank((String)groupname)) {
            throw new RemoteException("Can't add a blank group.");
        }
        if (!groupname.equals(groupname.toLowerCase())) {
            throw new RemoteException("A group name must be in lower case.");
        }
        if (!this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.getUser(), PermissionManager.TARGET_APPLICATION, Group.class)) {
            throw new NotPermittedException("You do not have permissions to create groups.");
        }
        if (this.userAccessor.getGroup(groupname) == null) {
            this.userAccessor.createGroup(groupname);
        }
        return true;
    }

    public boolean removeAllPermissionsForGroup(String groupname) throws RemoteException {
        Group group = this.userAccessor.getGroup(groupname);
        if (group == null) {
            throw new RemoteException("cannot delete permissions for non existing group");
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.SET_PERMISSIONS, (Object)group)) {
            throw new NotPermittedException("You do not have permissions to remove all permissions from the group " + groupname);
        }
        this.spacePermissionManager.removeAllPermissionsForGroup(groupname);
        return true;
    }

    public boolean removeGroup(String groupName, String moveToGroupName) throws RemoteException {
        Group group = this.userAccessor.getGroup(groupName);
        if (group == null) {
            throw new RemoteException("Group " + groupName + " does not exist.");
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.REMOVE, (Object)group)) {
            throw new NotPermittedException("You do not have permissions to remove this group: " + group.getName());
        }
        if (StringUtils.isNotBlank((String)moveToGroupName)) {
            Group moveToGroup = this.userAccessor.getGroup(moveToGroupName);
            if (moveToGroup == null) {
                throw new RemoteException("Cannot remove members of deleted group to " + moveToGroupName + " as it does not exist.");
            }
            if (this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.EDIT, (Object)moveToGroup)) {
                for (String username : this.userAccessor.getMemberNames(group)) {
                    this.userAccessor.addMembership(moveToGroup.getName(), username);
                }
            } else {
                throw new NotPermittedException("Cannot move members of deleted group " + groupName + " to " + moveToGroupName + " as " + AuthenticatedUserThreadLocal.getUsername() + " does not have group edit permissions.");
            }
        }
        this.userAccessor.removeGroup(group);
        return true;
    }

    public String[] getGroups() throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        List unfilteredGroups = this.userAccessor.getGroupsAsList();
        List filteredGroups = this.userAccessor.filterUnaccessibleGroups(unfilteredGroups, AuthenticatedUserThreadLocal.getUser());
        ArrayList<String> groups = new ArrayList<String>();
        for (Group group : filteredGroups) {
            groups.add(group.getName());
        }
        return groups.toArray(new String[groups.size()]);
    }

    public boolean deactivateUser(String username) throws NotPermittedException, RemoteException {
        User user = this.retrieveUser(username);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.SET_PERMISSIONS, (Object)user)) {
            throw new NotPermittedException("You do not have permissions to deactivate this user: " + user.getName());
        }
        if (this.userAccessor.isDeactivated(user)) {
            throw new RemoteException("User has already been deactivated");
        }
        this.userAccessor.deactivateUser(user);
        return true;
    }

    public boolean reactivateUser(String username) throws NotPermittedException, RemoteException {
        User user = this.retrieveUser(username);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.SET_PERMISSIONS, (Object)user)) {
            throw new NotPermittedException("You do not have permissions to reactivate this user: " + user.getName());
        }
        if (!this.userAccessor.isDeactivated(user)) {
            throw new RemoteException("User is already active");
        }
        this.userAccessor.reactivateUser(user);
        return true;
    }

    public boolean isActiveUser(String username) throws NotPermittedException, RemoteException {
        User user = this.retrieveUser(username);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, (Object)user)) {
            throw new NotPermittedException("You do not have permissions to check if this user is active: " + username);
        }
        return !this.userAccessor.isDeactivated(user);
    }

    public String[] getActiveUsers(boolean viewAll) throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        if (!viewAll) {
            List users = this.userAccessor.getUserNamesWithConfluenceAccess();
            return users.toArray(new String[users.size()]);
        }
        ArrayList result = Lists.newArrayList();
        for (User user : this.userAccessor.getUsers()) {
            result.add(user.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean changeMyPassword(String oldPass, String newPass) throws NotPermittedException, RemoteException {
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (!this.userAccessor.authenticate(currentUser.getName(), oldPass)) {
            throw new NotPermittedException("The current password was incorrect. Please try again.");
        }
        if (StringUtils.isBlank((String)newPass)) {
            throw new RemoteException("New password cannot be null or empty");
        }
        try {
            this.userAccessor.alterPassword(currentUser, newPass);
        }
        catch (EntityException e) {
            throw new RemoteException((Throwable)e);
        }
        return true;
    }

    public boolean changeUserPassword(String username, String newPass) throws NotPermittedException, RemoteException {
        User givenUser;
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(currentUser, Permission.EDIT, (Object)(givenUser = this.retrieveUser(username)))) {
            throw new NotPermittedException("You are not logged in as the correct user, or you do not have the correct permissions to perform this action.");
        }
        if (StringUtils.isBlank((String)newPass)) {
            throw new RemoteException("New password cannot be null or empty.");
        }
        try {
            this.userAccessor.alterPassword(givenUser, newPass);
        }
        catch (EntityException ee) {
            throw new RemoteException("Error changing password for user " + username, (Throwable)ee);
        }
        return true;
    }

    public boolean setUserInformation(RemoteUserInformation userInfo) throws RemoteException {
        User givenUser;
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(currentUser, Permission.EDIT, (Object)(givenUser = this.retrieveUser(userInfo.getUsername())))) {
            throw new NotPermittedException("You are not logged in as the correct user, or you do not have the correct permissions to perform this action.");
        }
        if (userInfo.getContent() != null) {
            PersonalInformation newInfo = this.personalInformationManager.getPersonalInformation(givenUser);
            PersonalInformation oldInfo = null;
            if (newInfo == null) {
                newInfo = new PersonalInformation(givenUser, this.userAccessor);
            } else {
                try {
                    oldInfo = (PersonalInformation)newInfo.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new RemoteException("Error saving personal information: Clone not supported");
                }
            }
            if (newInfo.getId() != userInfo.getId()) {
                throw new RemoteException("Error saving personal information: ID cannot be changed");
            }
            if (newInfo.getContent().equals(userInfo.getContent())) {
                return true;
            }
            newInfo.setContent(userInfo.getContent());
            this.personalInformationManager.savePersonalInformation(newInfo, oldInfo);
        }
        return true;
    }

    public RemoteUserInformation getUserInformation(String username) throws RemoteException {
        User givenUser = this.retrieveUser(username);
        PersonalInformation info = this.personalInformationManager.getPersonalInformation(givenUser);
        return info == null ? null : new RemoteUserInformation(info);
    }

    public boolean setUserPreferenceBoolean(String username, String key, boolean value) throws RemoteException {
        User givenUser = this.retrieveUser(username);
        this.checkUserCanEditObject(givenUser);
        try {
            this.userAccessor.getUserPreferences(givenUser).setBoolean(key, value);
        }
        catch (AtlassianCoreException e) {
            throw new RemoteException("Failed to set user preference.", (Throwable)e);
        }
        return true;
    }

    public boolean getUserPreferenceBoolean(String username, String key) throws RemoteException {
        User givenUser = this.retrieveUser(username);
        this.checkUserCanEditObject(givenUser);
        return this.userAccessor.getUserPreferences(givenUser).getBoolean(key);
    }

    public boolean setUserPreferenceLong(String username, String key, long value) throws RemoteException {
        User givenUser = this.retrieveUser(username);
        this.checkUserCanEditObject(givenUser);
        try {
            this.userAccessor.getUserPreferences(givenUser).setLong(key, value);
        }
        catch (AtlassianCoreException e) {
            throw new RemoteException("Failed to set user preference.", (Throwable)e);
        }
        return true;
    }

    public long getUserPreferenceLong(String username, String key) throws RemoteException {
        User givenUser = this.retrieveUser(username);
        this.checkUserCanEditObject(givenUser);
        return this.userAccessor.getUserPreferences(givenUser).getLong(key);
    }

    public boolean setUserPreferenceString(String username, String key, String value) throws RemoteException {
        User givenUser = this.retrieveUser(username);
        this.checkUserCanEditObject(givenUser);
        try {
            this.userAccessor.getUserPreferences(givenUser).setString(key, value);
        }
        catch (AtlassianCoreException e) {
            throw new RemoteException("Failed to set user preference.", (Throwable)e);
        }
        return true;
    }

    public String getUserPreferenceString(String username, String key) throws RemoteException {
        User givenUser = this.retrieveUser(username);
        this.checkUserCanEditObject(givenUser);
        return this.userAccessor.getUserPreferences(givenUser).getString(key);
    }

    public boolean hasUser(String username) {
        User user = this.userAccessor.getUser(username);
        return user != null;
    }

    public boolean hasGroup(String groupname) {
        Group group = this.userAccessor.getGroup(groupname);
        return group != null;
    }

    public PersonalInformationManager getPersonalInformationManager() {
        return this.personalInformationManager;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public boolean addProfilePicture(String userName, String fileName, String mimeType, byte[] pictureData) throws RemoteException {
        if (!mimeType.toLowerCase().startsWith("image/")) {
            throw new RemoteException("Invalid MIME type. Only image/* types may be used for profile pictures");
        }
        User user = this.userAccessor.getUser(userName);
        if (user == null) {
            throw new RemoteException("User does not exist");
        }
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(currentUser, Permission.EDIT, (Object)user)) {
            throw new NotPermittedException("You are not permitted to add a profile picture for the specified user");
        }
        File resizedProfilePicture = new ProfilePicture((InputStream)new ByteArrayInputStream(pictureData), fileName).create();
        if (resizedProfilePicture == null) {
            throw new RemoteException("There was a problem resizing the image");
        }
        PersonalInformation personalInfo = this.personalInformationManager.getPersonalInformation(user);
        Attachment attachment = this.attachmentManager.getAttachment((ContentEntityObject)personalInfo, fileName);
        Attachment previousVersion = null;
        if (attachment == null) {
            attachment = new Attachment();
        } else {
            try {
                previousVersion = (Attachment)attachment.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RemoteException("Error adding profile picture: Clone not supported");
            }
        }
        attachment.setContentType(mimeType);
        attachment.setFileName(fileName);
        attachment.setComment("Uploaded Profile Picture");
        attachment.setFileSize((long)pictureData.length);
        personalInfo.addAttachment(attachment);
        try {
            this.attachmentManager.saveAttachment(attachment, previousVersion, (InputStream)new ByteArrayInputStream(pictureData));
        }
        catch (IOException e) {
            throw new RemoteException("Error adding profile picture: Cound not save attachment");
        }
        UserPreferences userPreferences = new UserPreferences(this.userAccessor.getPropertySet(user));
        try {
            userPreferences.setString("confluence.user.profile.picture", fileName);
        }
        catch (AtlassianCoreException ex) {
            throw new RemoteException("Problem setting user preferences", (Throwable)ex);
        }
        return true;
    }
}

