/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.NodeStatus;
import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.ImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.impl.ExportUtils;
import com.atlassian.confluence.importexport.impl.UnexpectedImportZipFileContents;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.beans.RemoteClusterInformation;
import com.atlassian.confluence.rpc.soap.beans.RemoteNodeStatus;
import com.atlassian.confluence.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionCheckDispatcherResultCache;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.service.AnonymousUserPermissionsService;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.setup.settings.init.AdminUiProperties;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.XmlPluginArtifact;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminSoapService {
    private static final Logger log = LoggerFactory.getLogger(AdminSoapService.class);
    private ConfluenceIndexManager indexManager;
    private ImportExportManager importExportManager;
    private SpaceManager spaceManager;
    private GateKeeper gateKeeper;
    private SoapServiceHelper soapServiceHelper;
    private ClusterManager clusterManager;
    private PermissionManager permissionManager;
    private SettingsManager settingsManager;
    private PluginAccessor pluginAccessor;
    private PluginController pluginController;
    private AnonymousUserPermissionsService anonymousUserPermissionsService;
    private AdminUiProperties adminUiProperties;

    public boolean isConfluenceAdministrator(User user) throws RemoteException {
        return this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public String exportSite(boolean exportAttachments) throws RemoteException {
        String downloadPath = null;
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.isConfluenceAdministrator(user)) {
            throw new RemoteException("Authenticated user [" + user + "] is not a Confluence Administrator.");
        }
        try {
            DefaultExportContext exportContext = DefaultExportContext.getXmlBackupInstance();
            exportContext.setExportAttachments(exportAttachments);
            exportContext.setExportHierarchy(false);
            exportContext.setExportComments(false);
            String archivePath = this.importExportManager.exportAs((ExportContext)exportContext, new ProgressMeter());
            if (this.isDownloadEnabled()) {
                downloadPath = this.importExportManager.prepareDownloadPath(archivePath);
                this.gateKeeper.addKey(downloadPath, user);
                return this.settingsManager.getGlobalSettings().getBaseUrl() + downloadPath;
            }
            return "The backup was successfully created at " + archivePath + ". This file will be deleted in 24 hours.";
        }
        catch (ImportExportException e) {
            return "Could not export site: " + (Object)((Object)e);
        }
        catch (IOException e) {
            return "Could not export site: " + e;
        }
    }

    private boolean isDownloadEnabled() {
        return this.adminUiProperties.isAllowed("admin.ui.allow.manual.backup.download");
    }

    public RemoteServerInfo getServerInfo() throws RemoteException {
        return new RemoteServerInfo();
    }

    public boolean flushIndexQueue() throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        while (this.indexManager.isReIndexing()) {
            System.out.println("reindexing");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.indexManager.flushQueue();
        return true;
    }

    public boolean clearIndexQueue() throws RemoteException {
        this.soapServiceHelper.assertCanAdminister();
        this.indexManager.resetIndexQueue();
        return true;
    }

    public RemoteClusterInformation getClusterInformation() {
        return new RemoteClusterInformation(this.clusterManager.getClusterInformation());
    }

    public RemoteNodeStatus[] getClusterNodeStatuses() {
        ArrayList<RemoteNodeStatus> remoteNodeStatuses = new ArrayList<RemoteNodeStatus>();
        Map nodeStatuses = this.clusterManager.getNodeStatuses();
        for (Map.Entry entry : nodeStatuses.entrySet()) {
            remoteNodeStatuses.add(new RemoteNodeStatus((Integer)entry.getKey(), (NodeStatus)entry.getValue()));
        }
        return remoteNodeStatuses.toArray(new RemoteNodeStatus[remoteNodeStatuses.size()]);
    }

    public boolean importSpace(byte[] importData) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.isConfluenceAdministrator(user)) {
            throw new RemoteException("Authenticated user [" + user + "] is not a Confluence Administrator.");
        }
        try {
            File tmp = this.createTempFile("confluence-import-", ".tmp", importData);
            DefaultImportContext defaultImportContext = new DefaultImportContext(tmp.getAbsolutePath(), user);
            defaultImportContext.setDeleteWorkingFile(true);
            if (ExportUtils.isSpaceImport((File)tmp)) {
                String spaceKey = ExportUtils.getSpaceKeyFromExportZip((File)tmp);
                if (this.spaceManager.getSpace(spaceKey) != null) {
                    throw new RemoteException("Space " + spaceKey + " already exists.  Import aborted.");
                }
            } else {
                throw new RemoteException("Invalid import type - can only import spaces");
            }
            defaultImportContext.setSpaceKeyOfSpaceImport(ExportUtils.getSpaceKeyFromExportZip((File)tmp));
            this.importExportManager.importAs((Object)"TYPE_ALL_DATA", (ImportContext)defaultImportContext);
        }
        catch (ImportExportException e) {
            throw new RemoteException("Could not import space", (Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteException("Could not import space", (Throwable)e);
        }
        catch (UnexpectedImportZipFileContents unexpectedImportZipFileContents) {
            throw new RemoteException("Could not import space", (Throwable)unexpectedImportZipFileContents);
        }
        return true;
    }

    public boolean setEnableWysiwyg(boolean value) {
        Settings settings = this.settingsManager.getGlobalSettings();
        settings.setEnableWysiwyg(value);
        this.settingsManager.updateGlobalSettings(settings);
        return true;
    }

    public boolean isPluginInstalled(String pluginKey) {
        return this.pluginAccessor.getPlugin(pluginKey) != null;
    }

    public boolean isPluginEnabled(String pluginKey) {
        return this.pluginAccessor.isPluginEnabled(pluginKey);
    }

    public boolean installPlugin(final String pluginFileName, byte[] pluginData) throws RemoteException {
        File pluginFile;
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.isConfluenceAdministrator(user)) {
            throw new RemoteException("Authenticated user [" + user + "] is not a Confluence Administrator.");
        }
        int index = pluginFileName.lastIndexOf(".");
        if (index == -1) {
            throw new RemoteException("Cannot install plugin with bad filename. It must be a jar or xml file with the correct file extension.");
        }
        try {
            pluginFile = this.createTempFile(pluginFileName.substring(0, index), pluginFileName.substring(index + 1), pluginData);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not install plugin", e);
        }
        Object artifact = null;
        if (pluginFileName.endsWith(".jar")) {
            artifact = new JarPluginArtifact(pluginFile){

                public String getName() {
                    return pluginFileName;
                }
            };
        } else if (pluginFileName.endsWith(".xml")) {
            artifact = new XmlPluginArtifact(pluginFile){

                public String getName() {
                    return pluginFileName;
                }
            };
        }
        if (artifact != null) {
            this.pluginController.installPlugins(new PluginArtifact[]{artifact});
            return true;
        }
        return false;
    }

    private File createTempFile(String suffix, String prefix, byte[] data) throws IOException {
        File tmp = File.createTempFile(suffix, prefix);
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(tmp);
            fout.write(data);
            fout.close();
        }
        catch (IOException ex) {
            log.error("Unable to create temporary file", (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException ex) {}
        }
        return tmp;
    }

    public boolean setEnableAnonymousAccess(boolean value) {
        this.anonymousUserPermissionsService.setUsePermission(value);
        PermissionCheckDispatcherResultCache permissionCheckDispatcher = (PermissionCheckDispatcherResultCache)ContainerManager.getComponent((String)"permissionCheckDispatcherResultCache");
        if (permissionCheckDispatcher != null) {
            permissionCheckDispatcher.flush();
        }
        return true;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }

    public void setIndexManager(ConfluenceIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setPluginController(PluginController pluginController) {
        this.pluginController = pluginController;
    }

    public void setAnonymousUserPermissionsService(AnonymousUserPermissionsService anonymousUserPermissionsService) {
        this.anonymousUserPermissionsService = anonymousUserPermissionsService;
    }

    public void setAdminUiProperties(AdminUiProperties adminUiProperties) {
        this.adminUiProperties = adminUiProperties;
    }
}

