/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.roadmap.upgradetask;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.migration.AbstractExceptionTolerantMigrator;
import com.atlassian.confluence.content.render.xhtml.migration.BatchTask;
import com.atlassian.confluence.content.render.xhtml.migration.ExceptionTolerantMigrator;
import com.atlassian.confluence.content.render.xhtml.migration.WorkSourceBatchRunner;
import com.atlassian.confluence.content.render.xhtml.migration.exceptions.MigrationException;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.query.MacroUsageQuery;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugins.roadmap.upgradetask.ContentEntityMigrationBatchTask;
import com.atlassian.plugins.roadmap.upgradetask.SearchResultsBatchWorkSource;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

class CurrentSpacesParamMigrator {
    private static final Logger log = LoggerFactory.getLogger(CurrentSpacesParamMigrator.class);
    private static final String INDEX_FLUSH_JOB_NAME = "IndexQueueFlusher";
    private static final String CURRENT_SPACES_PARAM = "currentspaces";
    private static final String THREAD_NAME = "roadmap-macro-migration";
    private static final int BATCH_SIZE = 50;
    private static final int NUM_THREADS = 4;
    private final SearchManager searchManager;
    private final CustomContentManager contentManager;
    private final PlatformTransactionManager platformTransactionManager;
    private final XhtmlContent xhtmlContent;
    private final RoadmapMacroParamsContentEntityMigrator migrator;
    private volatile boolean inProgress = false;
    private AtomicInteger numFailed;
    private AtomicInteger numMigrated;
    private AtomicInteger numMigrationNotRequired;
    private final Function<Searchable, ContentEntityObject> searchableToCEOTransformer = new Function<Searchable, ContentEntityObject>(){

        public ContentEntityObject apply(Searchable from) {
            BodyContent bodyContent;
            if (from instanceof ContentEntityObject && (bodyContent = ((ContentEntityObject)from).getBodyContent()).getBodyType().equals((Object)BodyType.XHTML)) {
                return (ContentEntityObject)from;
            }
            return null;
        }
    };

    public CurrentSpacesParamMigrator(XhtmlContent xhtmlContent, SearchManager searchManager, CustomContentManager contentManager, PlatformTransactionManager platformTransactionManager) {
        this.contentManager = contentManager;
        this.searchManager = searchManager;
        this.platformTransactionManager = platformTransactionManager;
        this.xhtmlContent = xhtmlContent;
        this.migrator = new RoadmapMacroParamsContentEntityMigrator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate() throws MigrationException {
        CurrentSpacesParamMigrator currentSpacesParamMigrator = this;
        synchronized (currentSpacesParamMigrator) {
            if (this.inProgress) {
                throw new IllegalStateException("Another 'currentspaces' parameter migration is currently in progress");
            }
            this.resetMigrationFlags();
        }
        try {
            this.doMigration();
        }
        catch (SchedulerException e) {
            throw new MigrationException("Unable to pause or resume job: IndexQueueFlusher", (Throwable)e);
        }
        catch (InvalidSearchException e) {
            throw new MigrationException("Error searching for macro usages", (Throwable)e);
        }
        catch (Exception e) {
            throw new MigrationException((Throwable)e);
        }
        finally {
            this.inProgress = false;
        }
    }

    private void resetMigrationFlags() {
        this.inProgress = true;
        this.numFailed = new AtomicInteger(0);
        this.numMigrated = new AtomicInteger(0);
        this.numMigrationNotRequired = new AtomicInteger(0);
    }

    private void doMigration() throws Exception {
        log.info("Started migration of Roadmap macros");
        this.migrateCurrentContents();
        log.info("Finished migration of Roadmap macros:\n" + this.numMigrated + " Roadmap macro(s) were updated\n" + this.numMigrationNotRequired + " Roadmap macro(s) did not require any changes\n" + this.numFailed + " Roadmap macro(s) could not be updated\n");
    }

    private SearchResults findPagesWithRoadmapMacro() throws InvalidSearchException {
        MacroUsageQuery query = new MacroUsageQuery("roadmap");
        ContentSearch search = new ContentSearch((SearchQuery)query, null, null, 0, Integer.MAX_VALUE);
        return this.searchManager.search((ISearch)search);
    }

    private void migrateCurrentContents() throws Exception {
        SearchResults searchResults = this.findPagesWithRoadmapMacro();
        SearchResultsBatchWorkSource<ContentEntityObject> workSource = new SearchResultsBatchWorkSource<ContentEntityObject>(this.searchManager, searchResults.getAll(), 50, this.searchableToCEOTransformer);
        WorkSourceBatchRunner batchRunner = new WorkSourceBatchRunner(THREAD_NAME, 4, this.platformTransactionManager);
        ContentEntityMigrationBatchTask batchTask = new ContentEntityMigrationBatchTask((ExceptionTolerantMigrator)new RoadmapMacroParamsContentEntityMigrator(), (ContentEntityManager)this.contentManager);
        batchRunner.run(workSource, (BatchTask)batchTask);
    }

    class RoadmapMacroParamsContentEntityMigrator
    extends AbstractExceptionTolerantMigrator {
        RoadmapMacroParamsContentEntityMigrator() {
        }

        public ExceptionTolerantMigrator.MigrationResult migrate(String content, ConversionContext conversionContext) {
            try {
                final ArrayList migrations = Lists.newArrayList();
                String migratedContent = CurrentSpacesParamMigrator.this.xhtmlContent.updateMacroDefinitions(content, conversionContext, new MacroDefinitionUpdater(){

                    public MacroDefinition update(MacroDefinition macroDefinition) {
                        if (StringUtils.equals((CharSequence)macroDefinition.getName(), (CharSequence)"roadmap")) {
                            Map params = macroDefinition.getParameters();
                            if (params.containsKey(CurrentSpacesParamMigrator.CURRENT_SPACES_PARAM)) {
                                migrations.add(true);
                                RoadmapMacroParamsContentEntityMigrator.this.processParams(macroDefinition);
                                CurrentSpacesParamMigrator.this.numMigrated.incrementAndGet();
                            } else {
                                CurrentSpacesParamMigrator.this.numMigrationNotRequired.incrementAndGet();
                            }
                        }
                        return macroDefinition;
                    }
                });
                return new ExceptionTolerantMigrator.MigrationResult(migratedContent, migrations.size() > 0);
            }
            catch (XhtmlException e) {
                log.info("Encountered an exception during Roadmap macro migration", (Throwable)e);
                CurrentSpacesParamMigrator.this.numFailed.incrementAndGet();
                return new ExceptionTolerantMigrator.MigrationResult(content, false);
            }
        }

        private void processParams(MacroDefinition macroDefinition) {
            macroDefinition.setParameter(CurrentSpacesParamMigrator.CURRENT_SPACES_PARAM, null);
            macroDefinition.setTypedParameter(CurrentSpacesParamMigrator.CURRENT_SPACES_PARAM, null);
        }
    }
}

