/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.requestaccess.service;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.requestaccess.service.UserNotificationService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.security.Principal;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserNotificationServiceImpl
implements UserNotificationService {
    private static final int RECIPIENTS_LIMIT = 5;
    private final PermissionManager permissionManager;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;
    private final PageManager pageManager;

    @Autowired
    public UserNotificationServiceImpl(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager) {
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
    }

    @Override
    public LinkedHashSet<ConfluenceUser> findRequestAccessRecipient(AbstractPage page) {
        LinkedHashSet contributorsWithAccess = this.pageManager.getVersionHistorySummaries((ContentEntityObject)page).stream().sorted(Comparator.comparing(VersionHistorySummary::getLastModificationDate).reversed()).flatMap(diff -> diff.getContributors().stream()).distinct().filter(u -> this.hasPermissionsToGrantAccess((User)u, page)).limit(5L).collect(Collectors.toCollection(LinkedHashSet::new));
        if (contributorsWithAccess.size() == 5) {
            return contributorsWithAccess;
        }
        Set contributorNames = contributorsWithAccess.stream().map(Principal::getName).collect(Collectors.toSet());
        LinkedHashSet spaceAdminsWithAccess = this.spaceManager.getSpaceAdmins(page.getSpace()).stream().map(Principal::getName).filter(adminName -> !contributorNames.contains(adminName)).sorted().map(arg_0 -> ((UserAccessor)this.userAccessor).getUserByName(arg_0)).filter(u -> this.hasPermissionsToGrantAccess((User)u, page)).limit(5 - contributorNames.size()).collect(Collectors.toCollection(LinkedHashSet::new));
        return Stream.concat(contributorsWithAccess.stream(), spaceAdminsWithAccess.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private boolean hasPermissionsToGrantAccess(User user, AbstractPage page) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, (Object)page) && this.permissionManager.hasPermission(user, Permission.SET_PERMISSIONS, (Object)page);
    }
}

