define(
    "cp/component/annotation/annotation-header-view",
    [
        "backbone",
        "underscore",
        "jquery",
        "ajs",
        "MediaViewer",
        "core/template-store-singleton"
    ],
    function(
        Backbone,
        _,
        $,
        AJS,
        FileViewer,
        templateStore
        ) {

        "use strict";
        var AnnotationHeaderView = Backbone.View.extend({
            tagName: "div",

            className: "cp-annotation-header",

            events: {
                "click #cp-annotation-next": "next",
                "click #cp-annotation-previous": "previous"
            },

            initialize: function(options) {
                this.annotations = this.model.get("annotations");
                this.current = this.annotations.getCurrent();
                this._annotationView = options.annotationView;
                this.listenTo(this.annotations, "filterUpdated", this.render);
            },

            next: function() {
                this.annotations.next();
            },

            previous: function() {
                this.annotations.prev();
            },

            render: function() {
                this.$el.html(templateStore.get('Annotation.annotationHeader')({
                    current: this.annotations.currentIndexOf(this.current) + 1,
                    total: this.annotations.getCount(),
                    canDelete: this.current.get('hasDeletePermission'),
                    resolved: this.current.get('resolved')
                }));

                $(".tipsy").remove() && $.fn.tooltip && this.$el.find("a").tooltip();

                var deleteComment = _.bind(this.deleteComment, this);
                this.$el.find("#cp-annotations-more-menu").on({
                    "aui-dropdown2-show": function() {
                        $('body').on('click', '#cp-annotation-delete', deleteComment);
                    },
                    "aui-dropdown2-hide": function() {
                        $('body').off('click', '#cp-annotation-delete', deleteComment);
                    }
                });

                return this;
            },

            deleteComment: function (e) {
                e.preventDefault();
                var confirmed = window.confirm(AJS.I18n.getText('cp.annotations.delete.comment.confirmation.message'));
                if (confirmed) {
                    this._annotationView._closeEditor();
                    this.annotations.getCurrent().destroy({
                        wait: true,
                        error: this._handleError.bind(this)
                    });
                }
                $("#cp-annotation-more").trigger("aui-button-invoke");
            },

            _handleError: function() {
                this._generateError(AJS.I18n.getText('cp.annotations.save.fail'));
            },

            _generateError: function(error) {
                this._clearError();
                AJS.messages.warning(".cp-error", {
                    body: error
                });
            },

            _clearError: function() {
                $(".cp-error").empty();
            }
        });

        return AnnotationHeaderView;
    });

