define('cp/component/utils/editor-utils',
    [
        'jquery',
        'underscore',
        'ajs',
        'backbone',
        'exports'
    ],
    function(
        $,
        _,
        AJS,
        Backbone,
        exports
    ) {

    var unsupportedRtePlugins = [
            'dateautocomplete',
            'confluencemacrobrowser',
            'propertypanel',
            'jiraconnector',
            'dfe'
        ];

    var supportedRtePlugins = [
            'autoresize'
        ];

    /*
     * Return array of Rich Text Editor plugins that Previews does not support
     */
    function getUnsupportedRtePlugins() {
        return _.clone(unsupportedRtePlugins);
    }

    function getSupportedRtePlugins() {
        return _.clone(supportedRtePlugins);
    }

    function confirmProcess() {
        var openingEditor = AJS.Rte && AJS.Rte.getEditor();

        //hack so that dirty is only based on editor content changes
        if (openingEditor && openingEditor.getContent() !== "") {
            openingEditor.setDirty(true);
        }
        if (openingEditor && openingEditor.isDirty() && !$('.quick-comment-body .editor-container').length) {
            return window.confirm(AJS.I18n.getText("cp.annotations.editor.dirty.confirmation.message"));
        }

        return true;
    }

    exports.getUnsupportedRtePlugins = getUnsupportedRtePlugins;
    exports.getSupportedRtePlugins = getSupportedRtePlugins;
    exports.confirmProcess = confirmProcess;
});