define("cp/component/annotation/like",
    [
        "backbone",
        "jquery",
        "ajs"
    ],
    function(
        Backbone,
        $,
        AJS
        ) {
        "use strict";

        var Like = Backbone.Model.extend({
            defaults: {
                content_id: '',
                content_type: '',
                likes: [],
                summary: ''
            },

            //due to how the end point works, we only need to hit the end point with the correct comment id and it will
            //determine which user we are and then return the new likes object. thus we don't need to deal with the internals
            //of the backbone likes object too much
            sync: function (method, model, options) {
                if (method !== "create" && method !== "update" && method !== "delete") {
                    throw "Unsupported method in likes model: " + method;
                }

                return $.ajax({
                    url: AJS.contextPath() + "/rest/likes/1.0/content/" + options.id + "/likes",
                    type: method === "create" || method === "update" ? "POST" : "DELETE",
                    contentType: "application/json"
                }).done(function(resp) {
                    model.set(resp);
                    model.trigger("sync", model, resp, options);
                }).error(function(xhr) {
                    options.error && options.error(xhr);
                });
            }
        });

        return Like;
});