define('confluence/page-hierarchy/transformer/children-transformer',
    [],
    function () {
        /**
         * This transformer takes the results of a rest call to the children API and
         * converts it into a format for use inside this plugin.
         * @param {object} rest The original rest response
         * @returns {object} The transformed output
         */
        return function transformChildren(rest) {
            var next = rest._links.next;
            return {
                hasNext: !!next,
                next: next,
                results: rest.results
            };
        }
    });