define('confluence/page-hierarchy/fetch/fetch-content-restrictions', [
    'ajs'
], function (AJS) {
    var ENDPOINT = '/rest/api/content/<contentId>/restriction/byOperation';
    var $ = AJS.$;

    /**
     * Gets the restrictions for a piece of content by ID
     * @param {number} contentId The content Id
     * @returns {jQuery.Deferred} with the results from the rest call
     */
    function fetchContentRestrictions(contentId) {
        var deferred = $.Deferred();

        AJS.$.ajax({
            url: AJS.contextPath() + ENDPOINT.replace('<contentId>', contentId)
        }).done(function (data) {
            deferred.resolve(data);
        }).fail(function (data) {
            deferred.reject(data);
        });

        return deferred.promise();
    }

    return fetchContentRestrictions;
});