define('confluence/page-hierarchy/fetch/fetch-children-with-incoming-links', [
    'ajs',
    'confluence/page-hierarchy/transformer/children-transformer'
], function (AJS,
             transformChildren) {
    var ENDPOINT = '/rest/page-hierarchy/incoming/count'
        + '?rootContentId=<rootContentId>&parentContentId=<parentContentId>&start=0&limit=200';

    /**
     * Fetch the children of a piece of content with additional incoming links information.
     * Incoming links that originate from within the same hierarchy are excluded.
     * The root page of the hierarchy needs to be passed in in order to know which links need
     * to be excluded.
     * @param {number|string} parentContentId The parent page id
     * @param {number|string} rootContentId The id of the root page in the hierarchy
     * @returns {jQuery.Deferred} with the results
     */
    function fetchChildren(parentContentId, rootContentId) {
        var deferred = AJS.$.Deferred();
        AJS.$.ajax({
            url: AJS.contextPath() + ENDPOINT.replace('<rootContentId>', rootContentId)
                .replace('<parentContentId>', parentContentId),
            success: function (data) {
                deferred.resolve(transformChildren(data));
            }, error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

    return fetchChildren;
});