require([
    'underscore',
    'confluence/page-hierarchy/flow/copy-flow'
], function (
    _,
    Flow) {

    /**
     *
     * @param copyLinkSelectors an array of selectors for the Copy links
     */
    function handleCopyLinkActions(copyLinkSelectors) {
        copyLinkSelectors.forEach(function(copyLinkSelector) {
            var copyLink = $(copyLinkSelector);
            copyLink.off('click');
            copyLink.on('click', function (e) {
                e.preventDefault();
                Flow.startFlow();
            });
        });
    }

    // Intercept the regular click action and present the user with a dialog
    handleCopyLinkActions(['#action-copy-page-link', '#copyPageLink']);
    Flow.startFlow();
});

