define('confluence/page-hierarchy/action/delete-page-hierarchy-action', [
    'ajs'
], function (AJS) {
    var ENDPOINT = '/rest/page-hierarchy/delete';
    var $ = AJS.$;

    /**
     * Calls the rest end point to perform the delete action
     * @param {object} params Parameters to pass to the endpoint
     * {
     *      "deleteHierarchy": true,
     *      "targetPageId": 98798798
     *  }
     * @returns {jQuery.ajax} object from the request
     */
    function deleteAction(params) {
        if (!_checkParams(params)) {
            return $.Deferred().reject();
        }
        return _doDeleteAction(params);
    }

    function _doDeleteAction(params) {
        return $.ajax({
            type: 'POST',
            url: AJS.contextPath() + ENDPOINT,
            data: JSON.stringify($.extend(params, {atl_token: AJS.Meta.get('atl-token')})),
            contentType: 'application/json',
            dataType: 'json'
        });
    }

    function _checkParams(params) {
        return !!params;
    }

    return deleteAction;
});