/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.services;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.efi.rest.beans.RelevantSpaceBean;
import com.atlassian.confluence.efi.services.FindRelevantSpacesService;
import com.atlassian.confluence.search.actions.json.ContentNameMatch;
import com.atlassian.confluence.search.actions.json.ContentNameSearchResult;
import com.atlassian.confluence.search.contentnames.Category;
import com.atlassian.confluence.search.contentnames.ContentNameSearchService;
import com.atlassian.confluence.spaces.SpaceLogo;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class FindRelevantSpacesServiceImpl
implements FindRelevantSpacesService {
    private CQLSearchService cqlSearchService;
    private ContentNameSearchService contentNameSearchService;
    private SpaceManager spaceManager;

    public FindRelevantSpacesServiceImpl(CQLSearchService cqlSearchService, ContentNameSearchService contentNameSearchService, SpaceManager spaceManager) {
        this.cqlSearchService = cqlSearchService;
        this.contentNameSearchService = contentNameSearchService;
        this.spaceManager = spaceManager;
    }

    @Override
    public List<RelevantSpaceBean> getRelevantSpaces(HttpServletRequest httpServletRequest) {
        ArrayList relevantSpaces = Lists.newArrayList();
        this.addSpaceRankFromRecentlyCreatedPages(relevantSpaces, httpServletRequest);
        Collections.sort(relevantSpaces);
        return relevantSpaces;
    }

    @Override
    public List<RelevantSpaceBean> getRelevantSpaces(String query, HttpServletRequest httpServletRequest) {
        int maxHitsPerCategory = 10;
        ArrayList relevantSpaces = Lists.newArrayList();
        ContentNameSearchResult result = this.contentNameSearchService.search(query, (Iterable)Lists.newArrayList((Object[])new String[]{Category.SPACES.getName(), Category.PEOPLE.getName()}), null, 10, httpServletRequest);
        Iterable matches = Iterables.concat((Iterable)result.getContentNameMatches());
        String contextPath = this.getContextPath(httpServletRequest);
        for (ContentNameMatch match : matches) {
            if (this.isSearchForMore(match) || this.isUserWithoutPersonalSpace(match)) continue;
            relevantSpaces.add(new RelevantSpaceBean((String)Objects.firstNonNull((Object)match.getSpaceKey(), (Object)("~" + match.getUsername())), (String)Objects.firstNonNull((Object)match.getSpaceName(), (Object)match.getName()), 0, this.getIcon(match, contextPath)));
        }
        return relevantSpaces;
    }

    private Icon getIcon(ContentNameMatch match, String contextPath) {
        return match.getIcon() != null ? this.createIcon(match.getIcon()) : this.createIcon(this.spaceManager.getLogoForSpace(match.getSpaceKey()), contextPath);
    }

    private boolean isUserWithoutPersonalSpace(ContentNameMatch match) {
        return match.getUsername() != null && this.spaceManager.getPersonalSpace(match.getUsername()) == null;
    }

    private boolean isSearchForMore(ContentNameMatch match) {
        return "search-for".equals(match.getClassName());
    }

    private Icon createIcon(SpaceLogo logo, String contextPath) {
        return new Icon(contextPath + logo.getDownloadPath(), 48, 48, logo.isDefaultLogo());
    }

    private Icon createIcon(String path) {
        return new Icon(path, 48, 48, false);
    }

    private void addSpaceRankFromRecentlyCreatedPages(List<RelevantSpaceBean> relevantSpaces, HttpServletRequest httpServletRequest) {
        PageResponse response = this.cqlSearchService.searchContent("type in (page,blogpost) order by created desc", (PageRequest)new SimplePageRequest(0, 200), new Expansion[]{new Expansion("space", new Expansions(new Expansion[]{new Expansion("icon")}))});
        this.addRankFromPageHits(response.getResults(), relevantSpaces, httpServletRequest);
    }

    private void addRankFromPageHits(List<Content> contents, List<RelevantSpaceBean> relevantSpaces, HttpServletRequest httpServletRequest) {
        String contextPath = this.getContextPath(httpServletRequest);
        for (Content content : contents) {
            RelevantSpaceBean space = this.getSpaceWithKey(content.getSpace().getKey(), relevantSpaces);
            if (space != null) {
                space.setSpaceRank(space.getSpaceRank() + 1);
                continue;
            }
            Space spaceHit = content.getSpace();
            Icon icon = (Icon)spaceHit.getIconRef().get();
            Icon spaceIcon = new Icon(contextPath + icon.getPath(), icon.getWidth(), icon.getHeight(), icon.getIsDefault());
            boolean initialSpaceRank = true;
            relevantSpaces.add(new RelevantSpaceBean(spaceHit.getKey(), spaceHit.getName(), 1, spaceIcon));
        }
    }

    private String getContextPath(HttpServletRequest httpServletRequest) {
        return httpServletRequest == null ? new StaticHttpContext().getRequest().getContextPath() : httpServletRequest.getContextPath();
    }

    private RelevantSpaceBean getSpaceWithKey(final String key, List<RelevantSpaceBean> relevantSpaces) {
        return (RelevantSpaceBean)Iterables.find(relevantSpaces, (Predicate)new Predicate<RelevantSpaceBean>(){

            public boolean apply(RelevantSpaceBean relevantSpaceBean) {
                return key.equals(relevantSpaceBean.getKey());
            }
        }, null);
    }
}

