/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.emails.scheduling;

import com.atlassian.confluence.efi.emails.events.OnboardingEvent;
import com.atlassian.confluence.efi.emails.events.OnboardingLessUsersEvent;
import com.atlassian.confluence.efi.emails.scheduling.AbstractOnboardingJob;
import com.atlassian.confluence.efi.store.GlobalStorageService;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;

public class NumberOfUsersCheckJob
extends AbstractOnboardingJob {
    private static final int EXPECTED_NUMBER_OF_USERS = 5;
    private final UserChecker userChecker;

    public NumberOfUsersCheckJob(UserAccessor userAccessor, EventPublisher eventPublisher, CrowdService crowdService, GlobalStorageService globalStorageService, UserChecker userChecker) {
        super(userAccessor, eventPublisher, crowdService, globalStorageService);
        this.userChecker = userChecker;
    }

    @Override
    public void doExecute() {
        int numberOfRegisteredUsers = this.userChecker.getNumberOfRegisteredUsers();
        if (numberOfRegisteredUsers < 5) {
            this.triggerEvent();
        }
    }

    @Override
    protected OnboardingEvent createEventForUser(UserKey userKey) {
        return new OnboardingLessUsersEvent((Object)this, userKey);
    }
}

