define('confluence/ob/modules/tutorial/editor/editor', [
    'jquery'
], function ($) {
    'use strict';

    var editor = {};

    /**
     * Get the contents of the specified draft document.
     * @param draftID draftId
     * @returns {*}
     */
    editor.getDraftTemplates = function (draftID) {
        var restPath = AJS.contextPath() + "/rest/onboarding/1/draft/" + draftID + "/body/templates";
        return $.ajax({
            url: restPath,
            type: 'GET',
            contentType: "application/json",
            dataType: "json"
        });
    };

    editor.getCurrentContent = function () {
        return tinyMCE.activeEditor.getContent();
    };

    editor.setCurrentContent = function (content) {
        return tinyMCE.activeEditor.setContent(content);
    };

    editor.changePageName = function (value) {
        $('#editor-precursor #content-title').val(value);
    };

    editor.getPageName = function () {
        return $('#editor-precursor #content-title').val();
    };

    editor.isCreatingNewPage = function (window) {
        return !!window.location.pathname.match(/pages\/createpage.action|pages\/resumedraft.action/);
    };

    return editor;
});
