define('confluence/ob/modules/intro/intro-video-sequence', [
    'jquery',
    'confluence/ob/common/promise',
    'confluence/ob/common/youtube-player',
    'confluence/ob/modules/intro/intro-sequence-utils',
    'confluence/ob/common/user'
], function ($, Promise, YouTubePlayer, IntroSequenceUtils, User) {
    'use strict';

    var IntroVideoSequence = function(options) {
    };

    /**
     * @type SequenceInitFunction
     */
    IntroVideoSequence.prototype.init = function(container, analytics) {
        var self = this;

        return Promise(function(resolve, reject) {
            var $contentEl = IntroSequenceUtils.createProgressTracker('video');

            function onVideoFinished() {
                analytics.pushEvent(IntroVideoSequence.EVENTS.VIDEO_FINISHED);
                $content.find("#grow-intro-video-continue-button").removeClass("grow-intro-collapsed");
                $content.find("#grow-intro-video-skip-button").addClass("grow-intro-collapsed");
            }

            function onVideoClicked(event, params) {
                analytics.pushEvent(IntroVideoSequence.EVENTS.VIDEO_CLICKED + params.clickType);
            }

            var $content = $(Confluence.Templates.OB.video({
                name: User.getFullName()
            }));
            $content.find("#grow-intro-video-skip-button").click(function(){
                analytics.pushEvent(IntroVideoSequence.EVENTS.VIDEO_SKIP_BUTTON_CLICKED);
                self._sendVideoPlayedPercent(analytics);
                resolve("skip");
            });
            $content.find("#grow-intro-video-continue-button").click(function() {
                analytics.pushEvent(IntroVideoSequence.EVENTS.VIDEO_CONTINUE_BUTTON_CLICKED);
                self._sendVideoPlayedPercent(analytics);
                resolve("watched");
            });
            $contentEl.empty().append($content);

            $(YouTubePlayer)
                    .off(YouTubePlayer.EVENT_FINISH).on(YouTubePlayer.EVENT_FINISH, onVideoFinished)
                    .off(YouTubePlayer.EVENT_CLICK).on(YouTubePlayer.EVENT_CLICK, onVideoClicked);

            YouTubePlayer.embedVideo("grow-intro-video-placeholder", "09CuRQoJzB8", { width: 560, height:315, autoplay: 0, hl: User.getUserLocale()});
        });
    };

    IntroVideoSequence.prototype._sendVideoPlayedPercent = function(analytics) {
        var playedTime = YouTubePlayer.getCurrentTime();
        var duration = YouTubePlayer.getDuration();
        if (duration < 0) {
            analytics.pushEvent(IntroVideoSequence.EVENTS.VIDEO_NOT_SUPPORTED);
            return;
        }

        var progress = playedTime / duration * 100;

        var event = IntroVideoSequence.EVENTS.VIDEO_PLAYED_TO;
        if (progress <= 20) {
            event += "0.to.20";
        } else if (progress <= 40) {
            event += "21.to.40";
        } else if (progress <= 60) {
            event += "41.to.60";
        } else if (progress <= 80) {
            event += "61.to.80";
        } else {
            event += "81.to.100";
        }
        event += ".percent";

        analytics.pushEvent(event, {currentTime: playedTime, totalTime: duration });
    };

    IntroVideoSequence.EVENTS = {
        VIDEO_NOT_SUPPORTED: "intro.video.not.supported",
        VIDEO_CLICKED: "intro.video.clicked.",
        VIDEO_FINISHED: "intro.video.finished",
        VIDEO_PLAYED_TO: "intro.video.played.to.",
        VIDEO_CONTINUE_BUTTON_CLICKED: "intro.video.continue.button.clicked",
        VIDEO_SKIP_BUTTON_CLICKED: "intro.video.skip.button.clicked"
    };

    return IntroVideoSequence;
});