/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.impl;

import com.atlassian.confluence.core.SynchronizationManager;
import com.atlassian.confluence.notifications.DispatchService;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.ProductionAwareLoggerSwitch;
import com.atlassian.confluence.notifications.RecipientsProvider;
import com.atlassian.confluence.notifications.impl.NotificationDescriptorLocator;
import com.atlassian.confluence.notifications.impl.descriptors.AbstractParticipantDescriptor;
import com.atlassian.confluence.notifications.impl.descriptors.NotificationDescriptor;
import com.atlassian.fugue.Pair;
import com.atlassian.plugin.notifications.api.event.NotificationEvent;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.plugin.notifications.api.medium.recipient.UserKeyRoleRecipient;
import com.atlassian.plugin.notifications.api.queue.NotificationQueueManager;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.beans.factory.DisposableBean;

public class DefaultDispatchService
implements DispatchService,
DisposableBean {
    private static final ProductionAwareLoggerSwitch log = ProductionAwareLoggerSwitch.forClass(DefaultDispatchService.class);
    private static final String THREAD_PREFIX = DefaultDispatchService.class.getName();
    private static final String PROPERTY_MAX_SHUTDOWN_DELAY_SEC = "notifications.max.shutdown.delay.sec";
    private static final int MAX_THREADS = Integer.getInteger("notifications.api.commithook.dispatch.threads", 5);
    private final int maxShutdownDelay = Integer.getInteger("notifications.max.shutdown.delay.sec", 20);
    private final ExecutorService executorService;
    private final NotificationDescriptorLocator descriptorLocator;
    private final NotificationQueueManager queueManager;
    private final SynchronizationManager synchronizationManager;
    private final TransactionTemplate transactionTemplate;

    public DefaultDispatchService(NotificationDescriptorLocator descriptorLocator, NotificationQueueManager queueManager, SynchronizationManager synchronizationManager, TransactionTemplate transactionTemplate, ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.descriptorLocator = descriptorLocator;
        this.queueManager = queueManager;
        this.synchronizationManager = synchronizationManager;
        this.transactionTemplate = transactionTemplate;
        this.executorService = threadLocalDelegateExecutorFactory.createExecutorService(Executors.newFixedThreadPool(MAX_THREADS, ThreadFactories.namedThreadFactory((String)THREAD_PREFIX)));
    }

    @Override
    public void dispatch(Notification notification) {
        this.dispatchWithAdditionalRecipients(notification, Collections.EMPTY_LIST);
    }

    @Override
    public void dispatchWithAdditionalRecipients(Notification notification, Iterable<RoleRecipient> additionalRecipients) {
        NotificationDescriptor notificationDescriptor = (NotificationDescriptor)((Object)this.descriptorLocator.findNotificationDescriptor(notification.getPayload(), notification.getKey()).get());
        Iterable<RecipientsProvider> recipientsProviders = this.findRecipientProviders(notification);
        if (Iterables.isEmpty(recipientsProviders) && Iterables.isEmpty(additionalRecipients)) {
            log.warnOrDebug("No additional recipients were provided and no recipient providers for notification [%s] were found, thus aborting dispatch.", notification);
            return;
        }
        Callable<Iterable<RoleRecipient>> computeUserRecipients = () -> this.compileDistinctRecipients(Iterables.concat(this.collectUserBasedRecipients(notification, recipientsProviders), (Iterable)additionalRecipients));
        Callable<Iterable<NotificationAddress>> computeNonUserRecipients = () -> this.collectNonUserBasedRecipients(notification, recipientsProviders);
        this.dispatchForRecipients(notification, notificationDescriptor, computeUserRecipients, computeNonUserRecipients, (RecipientsProvider[])Iterables.toArray(recipientsProviders, RecipientsProvider.class));
    }

    private Iterable<NotificationAddress> collectNonUserBasedRecipients(Notification notification, Iterable<RecipientsProvider> recipientsProviders) {
        return Iterables.concat((Iterable)Iterables.transform(recipientsProviders, provider -> {
            try {
                return provider.nonUserBasedRecipientsFor(notification);
            }
            catch (RuntimeException e) {
                log.errorOrDebug(e);
                return Collections.EMPTY_LIST;
            }
        }));
    }

    @Override
    public void dispatchForExclusiveRecipients(Notification notification, Iterable<RoleRecipient> exlusiveRecipients) {
        NotificationDescriptor notificationDescriptor = (NotificationDescriptor)((Object)this.descriptorLocator.findNotificationDescriptor(notification.getPayload(), notification.getKey()).get());
        Callable<Iterable<RoleRecipient>> computeUserRecipients = () -> this.compileDistinctRecipients(exlusiveRecipients);
        Callable<Iterable<NotificationAddress>> computeNonUserRecipients = () -> Collections.EMPTY_LIST;
        this.dispatchForRecipients(notification, notificationDescriptor, computeUserRecipients, computeNonUserRecipients, new RecipientsProvider[0]);
    }

    private void dispatchForRecipients(Notification notification, NotificationDescriptor descriptor, Callable<Iterable<RoleRecipient>> computeUserRecipients, Callable<Iterable<NotificationAddress>> computeNonUserRecipients, RecipientsProvider ... recipientsProviders) {
        Runnable afterCommitHook = () -> this.executorService.submit(() -> {
            try {
                Pair r = (Pair)this.transactionTemplate.execute(() -> {
                    try {
                        Iterable userRecipients = (Iterable)computeUserRecipients.call();
                        Iterable nonUserRecipients = (Iterable)computeNonUserRecipients.call();
                        return Pair.pair((Object)userRecipients, (Object)nonUserRecipients);
                    }
                    catch (Exception e) {
                        log.errorOrDebug(e, "Error computing recipients", new Object[0]);
                        return Pair.pair(Collections.emptyList(), Collections.emptyList());
                    }
                });
                Iterable userRecipients = (Iterable)r.left();
                Iterable nonUserRecipients = (Iterable)r.right();
                if (Iterables.isEmpty((Iterable)userRecipients) && Iterables.isEmpty((Iterable)nonUserRecipients)) {
                    log.warnOrDebug("No recipients were compiled for notification [%s] from the following list of providers [%s], thus aborting dispatch.", notification, ToStringBuilder.reflectionToString((Object)recipientsProviders, (ToStringStyle)ToStringStyle.SIMPLE_STYLE));
                    return;
                }
                NotificationEvent notificationEvent = descriptor.getNotificationEventFactory().create(notification);
                if (!Iterables.isEmpty((Iterable)userRecipients)) {
                    this.queueManager.submitIndividualNotification(userRecipients, notificationEvent);
                }
                if (!Iterables.isEmpty((Iterable)nonUserRecipients)) {
                    this.queueManager.submitIndividualNotificationViaAddress(nonUserRecipients, notificationEvent);
                }
            }
            catch (IllegalStateException ex) {
                log.errorOrDebug(ex, "Error submitting email for generation, check your payload class is serialisable.", new Object[0]);
            }
            catch (Exception ex) {
                log.errorOrDebug(ex, "Error submitting email for generation", new Object[0]);
            }
        });
        if (this.synchronizationManager.isTransactionActive()) {
            log.onlyTrace("Registering transaction post-commit hook for dispatch of notification [%s]", notification);
            this.synchronizationManager.runOnSuccessfulCommit(afterCommitHook);
        } else {
            log.onlyTrace("No transaction active - directly dispatching notification [%s]", notification);
            afterCommitHook.run();
        }
    }

    private Iterable<UserKeyRoleRecipient> collectUserBasedRecipients(Notification notification, Iterable<RecipientsProvider> notificationRecipientsProviders) {
        return Iterables.concat((Iterable)Iterables.transform(notificationRecipientsProviders, provider -> {
            try {
                return provider.userBasedRecipientsFor(notification);
            }
            catch (RuntimeException e) {
                log.errorOrDebug(e);
                return Collections.EMPTY_LIST;
            }
        }));
    }

    private <T extends RoleRecipient> Iterable<T> compileDistinctRecipients(Iterable<T> recipients) {
        Comparator compareLexographically = (o1, o2) -> o1.getUserKey().getStringValue().compareTo(o2.getUserKey().getStringValue());
        return ImmutableSortedSet.copyOf((Comparator)compareLexographically, (Iterable)Iterables.filter(recipients, recipient -> UserKeyRoleRecipient.UNKNOWN != recipient));
    }

    private Iterable<RecipientsProvider> findRecipientProviders(Notification notification) {
        Object payload = notification.getPayload();
        Iterable<AbstractParticipantDescriptor<RecipientsProvider>> allRecipientProviders = this.descriptorLocator.findParticipantDescriptors(RecipientsProvider.class);
        return Iterables.filter((Iterable)Iterables.transform(allRecipientProviders, (Function)new Function<AbstractParticipantDescriptor<RecipientsProvider>, RecipientsProvider>(){

            public RecipientsProvider apply(@Nullable AbstractParticipantDescriptor<RecipientsProvider> descriptor) {
                return (RecipientsProvider)descriptor.getModule();
            }
        }), provider -> provider.getPayloadType().isAssignableFrom(payload.getClass()));
    }

    public void destroy() throws Exception {
        int numberOfUnprocessedExecutions = 0;
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(this.maxShutdownDelay, TimeUnit.SECONDS)) {
                numberOfUnprocessedExecutions = this.executorService.shutdownNow().size();
            }
        }
        catch (InterruptedException e) {
            numberOfUnprocessedExecutions = this.executorService.shutdownNow().size();
        }
        if (numberOfUnprocessedExecutions > 0) {
            log.warnOrDebug("There may be some emails still waiting to be sent on the queue, but the plugin is being shut down. %d queued notifications aborted", numberOfUnprocessedExecutions);
        }
    }
}

